/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import javax.validation.Validator;

public class BuildOutputBuilder
extends BuildOutputFluentImpl<BuildOutputBuilder>
implements VisitableBuilder<BuildOutput, BuildOutputBuilder> {
    BuildOutputFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildOutputBuilder() {
        this(true);
    }

    public BuildOutputBuilder(Boolean validationEnabled) {
        this(new BuildOutput(), validationEnabled);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildOutput(), validationEnabled);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, BuildOutput instance) {
        this(fluent, instance, true);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, BuildOutput instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImageLabels(instance.getImageLabels());
        fluent.withPushSecret(instance.getPushSecret());
        fluent.withTo(instance.getTo());
        this.validationEnabled = validationEnabled;
    }

    public BuildOutputBuilder(BuildOutput instance) {
        this(instance, (Boolean)true);
    }

    public BuildOutputBuilder(BuildOutput instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImageLabels(instance.getImageLabels());
        this.withPushSecret(instance.getPushSecret());
        this.withTo(instance.getTo());
        this.validationEnabled = validationEnabled;
    }

    public BuildOutputBuilder(Validator validator) {
        this(new BuildOutput(), (Boolean)true);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, BuildOutput instance, Validator validator) {
        this.fluent = fluent;
        fluent.withImageLabels(instance.getImageLabels());
        fluent.withPushSecret(instance.getPushSecret());
        fluent.withTo(instance.getTo());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildOutputBuilder(BuildOutput instance, Validator validator) {
        this.fluent = this;
        this.withImageLabels(instance.getImageLabels());
        this.withPushSecret(instance.getPushSecret());
        this.withTo(instance.getTo());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BuildOutput build() {
        BuildOutput buildable = new BuildOutput(this.fluent.getImageLabels(), this.fluent.getPushSecret(), this.fluent.getTo());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildOutputBuilder that = (BuildOutputBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

