/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.executor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.guvnor.ala.build.Binary;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.build.maven.util.MavenBuildExecutor;
import org.guvnor.ala.openshift.dns.OpenShiftNameService;
import org.guvnor.ala.openshift.executor.OpenShiftExecutorTest;
import org.guvnor.ala.registry.BuildRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftMavenDeployer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftMavenDeployer.class);
    private final File workDir;
    private final String nexusHostPrefix;

    public OpenShiftMavenDeployer(File workDir, String appName, String prjName) throws Exception {
        this.workDir = workDir;
        this.nexusHostPrefix = appName + "-nexus-" + prjName;
    }

    public boolean deploy(BuildRegistry buildRegistry) throws Exception {
        return this.deploy(buildRegistry.getAllBinaries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deploy(List<Binary> binaries) throws Exception {
        URL nexusContentURL = this.getNexusContentURL(true);
        if (nexusContentURL == null) {
            return false;
        }
        String origCustomSettingsProp = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", this.generateSettingsXml());
            MavenSettings.reinitSettings();
            for (Binary binary : binaries) {
                MavenBinary mavenBinary = (MavenBinary)binary;
                File pom = new File(mavenBinary.getProject().getTempDir(), "pom.xml");
                Properties props = new Properties();
                boolean isSnapshot = mavenBinary.getVersion().endsWith("SNAPSHOT");
                String nexusRepoUrl = nexusContentURL + "repositories/" + (isSnapshot ? "snapshots/" : "releases/");
                props.setProperty("altDeploymentRepository", "nexus::default::" + nexusRepoUrl);
                MavenBuildExecutor.executeMaven((File)pom, (Properties)props, (String[])new String[]{"deploy"});
            }
        }
        finally {
            if (origCustomSettingsProp != null) {
                System.setProperty("kie.maven.settings.custom", origCustomSettingsProp);
            } else {
                System.clearProperty("kie.maven.settings.custom");
            }
            MavenSettings.reinitSettings();
        }
        return true;
    }

    private URL getNexusContentURL(boolean checkConnection) throws Exception {
        URL nexusContentURL = null;
        for (String hostName : OpenShiftNameService.getHosts()) {
            if (!hostName.startsWith(this.nexusHostPrefix)) continue;
            nexusContentURL = new URL("http://" + hostName + "/nexus/content/");
            break;
        }
        if (nexusContentURL == null) {
            LOG.warn(String.format("Unknown Nexus host with prefix: %s", this.nexusHostPrefix));
        } else if (checkConnection && !OpenShiftExecutorTest.checkConnection(nexusContentURL, 200, 60, 1000L)) {
            LOG.warn(String.format("%s is not reachable.", nexusContentURL));
            nexusContentURL = null;
        }
        return nexusContentURL;
    }

    private String generateSettingsXml() throws IOException {
        String settingsXml = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                       http://maven.apache.org/xsd/settings-1.0.0.xsd\">\n  <servers>\n      <server>\n          <id>nexus</id>\n          <username>admin</username>\n          <password>admin123</password>\n      </server>\n  </servers>\n</settings>\n";
        Path settingsXmlPath = Files.createTempFile(this.workDir.toPath(), "settings-", ".xml", new FileAttribute[0]);
        Files.write(settingsXmlPath, settingsXml.getBytes(), new OpenOption[0]);
        return settingsXmlPath.toAbsolutePath().toString();
    }
}

