/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.access.impl;

import io.fabric8.openshift.client.OpenShiftConfig;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.SortedMap;
import org.guvnor.ala.openshift.access.OpenShiftRuntimeId;
import org.guvnor.ala.openshift.access.OpenShiftTemplate;
import org.guvnor.ala.openshift.access.impl.OpenShiftAccessInterfaceImpl;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.config.impl.OpenShiftProviderConfigImpl;
import org.junit.Assert;
import org.junit.Test;

public class OpenShiftAccessTest {
    @Test
    public void testGoodRuntimeId() {
        String expectedPrj = "myProject";
        String expectedSvc = "myService";
        String expectedApp = "myApplication";
        OpenShiftRuntimeId oldId = new OpenShiftRuntimeId("myProject", "myService", "myApplication");
        OpenShiftRuntimeId newId = OpenShiftRuntimeId.fromString((String)oldId.toString());
        Assert.assertEquals((Object)"myProject", (Object)newId.project());
        Assert.assertEquals((Object)"myService", (Object)newId.service());
        Assert.assertEquals((Object)"myApplication", (Object)newId.application());
        Assert.assertEquals((Object)oldId, (Object)newId);
    }

    @Test
    public void testBadRuntimeId() {
        String nullStr = null;
        String emptyStr = "";
        String blankStr = " ";
        String validStr = "valid";
        try {
            new OpenShiftRuntimeId(nullStr, "valid", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("", "valid", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId(" ", "valid", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", nullStr, "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", " ", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "valid", nullStr);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "valid", "");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "valid", " ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testProviderConfig() {
        OpenShiftProviderConfigImpl providerConfig = new OpenShiftProviderConfigImpl().clear();
        providerConfig.setKubernetesMaster("https://localhost:8443");
        providerConfig.setKubernetesOapiVersion("v2");
        OpenShiftConfig clientConfig = OpenShiftAccessInterfaceImpl.buildOpenShiftConfig((OpenShiftProviderConfig)providerConfig);
        Assert.assertEquals((Object)"https://localhost:8443/", (Object)clientConfig.getMasterUrl());
        Assert.assertEquals((Object)"https://localhost:8443/oapi/v2/", (Object)clientConfig.getOpenShiftUrl());
    }

    @Test
    public void testTemplateParams() throws Exception {
        String templateUri = this.getUri("bpmsuite70-execserv.json");
        OpenShiftTemplate template = new OpenShiftTemplate(templateUri);
        SortedMap params = template.getParameterMap();
        this.verifyParameter(params, "APPLICATION_NAME", "Application Name", "The name for the application.", true, null, null, "myapp");
        this.verifyParameter(params, "KIE_SERVER_PWD", "KIE Server Password", "KIE execution server password (Sets the org.kie.server.pwd system property)", false, "expression", "[a-zA-Z]{6}[0-9]{1}!", null);
    }

    private void verifyParameter(Map<String, OpenShiftTemplate.Parameter> params, String name, String displayName, String description, boolean required, String generate, String from, String value) {
        OpenShiftTemplate.Parameter param = params.get(name);
        Assert.assertEquals((Object)name, (Object)param.getName());
        Assert.assertEquals((Object)displayName, (Object)param.getDisplayName());
        Assert.assertEquals((Object)description, (Object)param.getDescription());
        Assert.assertEquals((Object)required, (Object)param.isRequired());
        Assert.assertEquals((Object)generate, (Object)param.getGenerate());
        Assert.assertEquals((Object)from, (Object)param.getFrom());
        Assert.assertEquals((Object)value, (Object)param.getValue());
    }

    private String getUri(String resourcePath) throws URISyntaxException {
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        return this.getClass().getResource(resourcePath).toURI().toString();
    }
}

