/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.pipeline.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigParamsChangeEvent;
import org.guvnor.ala.ui.openshift.client.pipeline.template.TemplateParamsFormPresenter;
import org.guvnor.ala.ui.openshift.client.pipeline.template.table.TemplateParamsTablePresenter;
import org.guvnor.ala.ui.openshift.client.validation.OpenShiftClientValidationService;
import org.guvnor.ala.ui.openshift.model.DefaultSettings;
import org.guvnor.ala.ui.openshift.model.TemplateDescriptorModel;
import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.guvnor.ala.ui.openshift.service.OpenShiftClientService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class TemplateParamsFormPresenterTest {
    private static final String TITLE = "TITLE";
    private static final String RUNTIME_NAME_VALUE = "RUNTIME_NAME_VALUE";
    private static final String DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE = "DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE";
    private static final String DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE = "DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE";
    private static final String DEFAULT_OPEN_SHIFT_SECRETS_VALUE = "DEFAULT_OPEN_SHIFT_SECRETS_VALUE";
    private static final int REQUIRED_TEMPLATE_PARAMS_COUNT = 5;
    private static final int NON_REQUIRED_TEMPLATE_PARAMS_COUNT = 5;
    private static final String PARAMS_NOT_COMPLETED_MESSAGE = "PARAMS_NOT_COMPLETED_MESSAGE";
    private static final String GET_TEMPLATE_ERROR_MESSAGE = "GET_TEMPLATE_ERROR_MESSAGE";
    private static final String RUNTIME_NAME_ERROR_MESSAGE = "RUNTIME_NAME_ERROR_MESSAGE";
    private static final int CONTAINER_CONFIG_COUNT = 10;
    @Mock
    private TemplateParamsFormPresenter.View view;
    @Mock
    private TemplateParamsTablePresenter paramsEditorPresenter;
    @Mock
    private TemplateParamsTablePresenter.View paramsEditorPresenterView;
    @Mock
    private TranslationService translationService;
    @Mock
    private PopupHelper popupHelper;
    private Caller<OpenShiftClientService> openshiftClientServiceCaller;
    @Mock
    private OpenShiftClientService openShiftClientService;
    private OpenShiftClientValidationService openShiftClientValidationService;
    private TemplateParamsFormPresenter presenter;
    private List<TemplateParam> allTemplateParams;
    private List<TemplateParam> managedTemplateParams;
    private List<TemplateParam> requiredTemplateParams;
    private List<TemplateParam> nonRequiredTemplateParams;
    private List<TemplateParam> bannedTemplateParams;
    @Mock
    private TemplateDescriptorModel templateDescriptorModel;
    @Mock
    private ErrorCallback<Message> errorCallback;
    private ArgumentCaptor<Throwable> exceptionCaptor;

    @Before
    public void setUp() {
        Mockito.when((Object)this.popupHelper.getPopupErrorCallback()).thenReturn(this.errorCallback);
        this.exceptionCaptor = ArgumentCaptor.forClass(Throwable.class);
        this.initializeParams();
        Mockito.when((Object)this.templateDescriptorModel.getParams()).thenReturn(this.allTemplateParams);
        Mockito.when((Object)this.paramsEditorPresenter.getView()).thenReturn((Object)this.paramsEditorPresenterView);
        this.openshiftClientServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.openShiftClientService));
        this.openShiftClientValidationService = new OpenShiftClientValidationService(this.openshiftClientServiceCaller);
        this.presenter = (TemplateParamsFormPresenter)Mockito.spy((Object)new TemplateParamsFormPresenter(this.view, this.paramsEditorPresenter, this.translationService, this.popupHelper, this.openshiftClientServiceCaller, this.openShiftClientValidationService));
        this.presenter.init();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setParamsEditorPresenter((IsElement)this.paramsEditorPresenterView);
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.times((int)1))).setParamChangeHandler((TemplateParamsTablePresenter.ParamChangeHandler)ArgumentMatchers.any());
    }

    private void initializeParams() {
        this.requiredTemplateParams = this.mockParams("required", 5, true);
        this.nonRequiredTemplateParams = this.mockParams("nonRequired", 5, false);
        this.bannedTemplateParams = new ArrayList<TemplateParam>();
        this.bannedTemplateParams.add(new TemplateParam("IMAGE_STREAM_NAMESPACE", null, null, true, null));
        this.bannedTemplateParams.add(new TemplateParam("APPLICATION_NAME", null, null, true, null));
        this.allTemplateParams = new ArrayList<TemplateParam>();
        this.allTemplateParams.addAll(this.requiredTemplateParams);
        this.allTemplateParams.addAll(this.nonRequiredTemplateParams);
        this.allTemplateParams.addAll(this.bannedTemplateParams);
        this.managedTemplateParams = new ArrayList<TemplateParam>();
        this.managedTemplateParams.addAll(this.requiredTemplateParams);
        this.managedTemplateParams.addAll(this.nonRequiredTemplateParams);
    }

    @Test
    public void testGetWizardTitle() {
        Mockito.when((Object)this.view.getWizardTitle()).thenReturn((Object)TITLE);
        Assert.assertEquals((Object)TITLE, (Object)this.presenter.getWizardTitle());
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testInitializeSuccessful() {
        DefaultSettings defaultSettings = (DefaultSettings)Mockito.mock(DefaultSettings.class);
        Mockito.when((Object)defaultSettings.getValue("org.kie.provisioning.openshift.defaultTemplate")).thenReturn((Object)DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        Mockito.when((Object)defaultSettings.getValue("org.kie.provisioning.openshift.defaultImageStreams")).thenReturn((Object)DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        Mockito.when((Object)defaultSettings.getValue("org.kie.provisioning.openshift.defaultSecrets")).thenReturn((Object)DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
        Mockito.when((Object)this.openShiftClientService.getDefaultSettings()).thenReturn((Object)defaultSettings);
        Mockito.when((Object)this.openShiftClientService.getTemplateModel(DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE)).thenReturn((Object)this.templateDescriptorModel);
        this.presenter.initialise();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setTemplateURL(DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setImageStreamsURL(DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSecretsFileURL(DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
    }

    @Test
    public void testInitializeFailed() {
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.openShiftClientService, this.openshiftClientServiceCaller);
        this.presenter.initialise();
        ((ErrorCallback)Mockito.verify(this.errorCallback, (VerificationMode)Mockito.times((int)1))).error(ArgumentMatchers.any(Message.class), (Throwable)this.exceptionCaptor.capture());
        Assert.assertEquals((Object)"SERVICE_CALLER_EXCEPTION_MESSAGE", (Object)((Throwable)this.exceptionCaptor.getValue()).getMessage());
    }

    @Test
    public void testPrepareView() {
        this.presenter.prepareView();
        ((TemplateParamsTablePresenter.View)Mockito.verify((Object)this.paramsEditorPresenterView, (VerificationMode)Mockito.times((int)1))).redraw();
    }

    @Test
    public void testIsComplete() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getImageStreamsURL()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getSecretsFileURL()).thenReturn((Object)"");
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME_VALUE);
        Mockito.when((Object)this.openShiftClientService.isValidProjectName(RUNTIME_NAME_VALUE)).thenReturn((Object)true);
        this.presenter.onRuntimeNameChange();
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getImageStreamsURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getSecretsFileURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getTemplateURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        Mockito.when((Object)this.openShiftClientService.getTemplateModel(DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE)).thenReturn((Object)this.templateDescriptorModel);
        this.presenter.onTemplateURLChange();
        this.presenter.isComplete(Assert::assertFalse);
        this.requiredTemplateParams.forEach(param -> param.setValue("some value"));
        this.presenter.isComplete(Assert::assertTrue);
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.times((int)1))).clear();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRequiredParamsHelpText();
    }

    @Test
    public void testOnRuntimeNameChangeValid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME_VALUE);
        Mockito.when((Object)this.openShiftClientService.isValidProjectName(RUNTIME_NAME_VALUE)).thenReturn((Object)true);
        this.presenter.onRuntimeNameChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeNameStatus(FormStatus.VALID);
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRuntimeNameHelpText();
        ((TemplateParamsFormPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnRuntimeNameInvalid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME_VALUE);
        Mockito.when((Object)this.openShiftClientService.isValidProjectName(RUNTIME_NAME_VALUE)).thenReturn((Object)false);
        Mockito.when((Object)this.translationService.getTranslation("TemplateParamsFormPresenter.InvalidProjectNameError")).thenReturn((Object)RUNTIME_NAME_ERROR_MESSAGE);
        this.presenter.onRuntimeNameChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeNameStatus(FormStatus.ERROR);
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeNameHelpText(RUNTIME_NAME_ERROR_MESSAGE);
        ((TemplateParamsFormPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnTemplateURLChangeInvalid() {
        Mockito.when((Object)this.view.getTemplateURL()).thenReturn((Object)"");
        this.presenter.onTemplateURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setTemplateURLStatus(FormStatus.ERROR);
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.times((int)1))).clear();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRequiredParamsHelpText();
    }

    @Test
    public void testOnTemplateURLChangeValidLoadSuccessful() {
        Mockito.when((Object)this.translationService.getTranslation("TemplateParamsFormPresenter.RequiredParamsNotCompletedMessage")).thenReturn((Object)PARAMS_NOT_COMPLETED_MESSAGE);
        Mockito.when((Object)this.view.getTemplateURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        Mockito.when((Object)this.openShiftClientService.getTemplateModel(DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE)).thenReturn((Object)this.templateDescriptorModel);
        this.presenter.onTemplateURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setTemplateURLStatus(FormStatus.VALID);
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.times((int)1))).clear();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearRequiredParamsHelpText();
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.times((int)1))).setItems(this.managedTemplateParams);
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRequiredParamsHelpText(PARAMS_NOT_COMPLETED_MESSAGE);
    }

    @Test
    public void testOnTemplateURLChangeValidLoadFailed() {
        Mockito.when((Object)this.translationService.getTranslation("TemplateParamsFormPresenter.GetTemplateFileConfigError")).thenReturn((Object)GET_TEMPLATE_ERROR_MESSAGE);
        Mockito.when((Object)this.view.getTemplateURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.openShiftClientService, this.openshiftClientServiceCaller);
        this.presenter.onTemplateURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setTemplateURLStatus(FormStatus.ERROR);
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.times((int)1))).clear();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRequiredParamsHelpText();
        ((TemplateParamsTablePresenter)Mockito.verify((Object)this.paramsEditorPresenter, (VerificationMode)Mockito.never())).setItems((List)ArgumentMatchers.any());
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showErrorPopup("GET_TEMPLATE_ERROR_MESSAGE: SERVICE_CALLER_EXCEPTION_MESSAGE");
    }

    @Test
    public void testOnImageStreamsURLChangeValid() {
        Mockito.when((Object)this.view.getImageStreamsURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        this.presenter.onImageStreamsURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setImageStreamsURLStatus(FormStatus.VALID);
        ((TemplateParamsFormPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnImageStreamsURLChangeInvalid() {
        Mockito.when((Object)this.view.getImageStreamsURL()).thenReturn((Object)"");
        this.presenter.onImageStreamsURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setImageStreamsURLStatus(FormStatus.ERROR);
        ((TemplateParamsFormPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnSecretsFileURLChangeValid() {
        Mockito.when((Object)this.view.getSecretsFileURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
        this.presenter.onSecretsFileURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSecretsFileURLStatus(FormStatus.VALID);
        ((TemplateParamsFormPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnSecretsFileURLChangeInvalid() {
        Mockito.when((Object)this.view.getSecretsFileURL()).thenReturn((Object)"");
        this.presenter.onSecretsFileURLChange();
        ((TemplateParamsFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSecretsFileURLStatus(FormStatus.ERROR);
        ((TemplateParamsFormPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnContainerConfigurationsChangeWithConfigs() {
        List<ContainerConfig> containerConfigs = this.mockContainerConfigList(10);
        this.presenter.onContainerConfigurationsChange(new ContainerConfigParamsChangeEvent(containerConfigs));
        Map params = this.presenter.buildParams();
        String containerParam = (String)params.get("org-kie-server-container-deployment");
        String expectedContainerParam = this.buildExpectedContainerDeploymentParamValue(containerConfigs);
        Assert.assertEquals((Object)expectedContainerParam, (Object)containerParam);
    }

    @Test
    public void testOnContainerConfigurationsChangeWithNoConfigs() {
        this.presenter.onContainerConfigurationsChange(new ContainerConfigParamsChangeEvent(new ArrayList()));
        Map params = this.presenter.buildParams();
        String containerParam = (String)params.get("org-kie-server-container-deployment");
        Assert.assertNull((Object)containerParam);
    }

    @Test
    public void testBuildParams() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME_VALUE);
        Mockito.when((Object)this.view.getImageStreamsURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        Mockito.when((Object)this.view.getSecretsFileURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
        Mockito.when((Object)this.openShiftClientService.isValidProjectName(RUNTIME_NAME_VALUE)).thenReturn((Object)true);
        this.presenter.onRuntimeNameChange();
        Mockito.when((Object)this.view.getTemplateURL()).thenReturn((Object)DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        Mockito.when((Object)this.openShiftClientService.getTemplateModel(DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE)).thenReturn((Object)this.templateDescriptorModel);
        this.presenter.onTemplateURLChange();
        List<ContainerConfig> containerConfigs = this.mockContainerConfigList(10);
        this.presenter.onContainerConfigurationsChange(new ContainerConfigParamsChangeEvent(containerConfigs));
        for (int i = 0; i < this.allTemplateParams.size(); ++i) {
            String paramValue = "PARAM_VALUE" + String.valueOf(i);
            this.allTemplateParams.get(i).setValue(paramValue);
        }
        StringBuilder templateParamsValueBuilder = new StringBuilder();
        this.managedTemplateParams.forEach(param -> {
            if (templateParamsValueBuilder.length() > 0) {
                templateParamsValueBuilder.append(",");
            }
            templateParamsValueBuilder.append(param.getName());
            templateParamsValueBuilder.append("=");
            templateParamsValueBuilder.append(param.getValue());
        });
        templateParamsValueBuilder.append(",IMAGE_STREAM_NAMESPACE=RUNTIME_NAME_VALUE");
        templateParamsValueBuilder.append(",APPLICATION_NAME=RUNTIME_NAME_VALUE");
        HashMap<String, String> expectedParams = new HashMap<String, String>();
        expectedParams.put("runtime-name", RUNTIME_NAME_VALUE);
        expectedParams.put("project-name", RUNTIME_NAME_VALUE);
        expectedParams.put("application-name", RUNTIME_NAME_VALUE);
        expectedParams.put("service-name", "RUNTIME_NAME_VALUE-execserv");
        expectedParams.put("resource-template-uri", DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        expectedParams.put("resource-streams-uri", DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        expectedParams.put("resource-secrets-uri", DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
        expectedParams.put("org-kie-server-container-deployment", this.buildExpectedContainerDeploymentParamValue(containerConfigs));
        expectedParams.put("resource-template-param-values", templateParamsValueBuilder.toString());
        Map result = this.presenter.buildParams();
        Assert.assertEquals(expectedParams, (Object)result);
    }

    private List<TemplateParam> mockParams(String prefix, int count, boolean required) {
        ArrayList<TemplateParam> params = new ArrayList<TemplateParam>();
        for (int i = 0; i < count; ++i) {
            params.add(new TemplateParam(prefix + ".name." + i, null, null, required, null));
        }
        return params;
    }

    private String buildExpectedContainerDeploymentParamValue(List<ContainerConfig> containerConfigs) {
        return this.presenter.buildContainerDeploymentParamValue(containerConfigs);
    }

    private List<ContainerConfig> mockContainerConfigList(int count) {
        ArrayList<ContainerConfig> result = new ArrayList<ContainerConfig>();
        for (int i = 0; i < count; ++i) {
            result.add(this.mockContainerConfig(String.valueOf(i)));
        }
        return result;
    }

    private ContainerConfig mockContainerConfig(String suffix) {
        return new ContainerConfig("ContainerConfig.name." + suffix, "ContainerConfig.groupId." + suffix, "ContainerConfig.artifactId." + suffix, "ContainerConfig.version." + suffix);
    }
}

