/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.provider;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class OpenShiftProviderConfigPresenter
extends AbstractHasContentChangeHandlers
implements ProviderConfigurationForm {
    protected static final String MAIN_URL = "kubernetes-main";
    protected static final String USER = "kubernetes-auth-basic-username";
    protected static final String PASSWORD = "kubernetes-auth-basic-password";
    private final View view;

    @Inject
    public OpenShiftProviderConfigPresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public ProviderConfiguration buildProviderConfiguration() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(MAIN_URL, this.getMainURL());
        values.put(USER, this.getUsername());
        values.put(PASSWORD, this.getPassword());
        return new ProviderConfiguration(this.getProviderName(), values);
    }

    public void clear() {
        this.view.clear();
    }

    public void load(Provider provider) {
        this.clear();
        this.view.setProviderName(((ProviderKey)provider.getKey()).getId());
        this.view.setMainURL(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)MAIN_URL));
        this.view.setUsername(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)USER));
        this.view.setPassword(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)PASSWORD));
    }

    public String getProviderName() {
        return this.view.getProviderName();
    }

    public String getMainURL() {
        return this.view.getMainURL();
    }

    public String getUsername() {
        return this.view.getUsername();
    }

    public String getPassword() {
        return this.view.getPassword();
    }

    public void isValid(Callback<Boolean> callback) {
        boolean isValid = !this.isEmpty(this.view.getProviderName()) && !this.isEmpty(this.view.getMainURL()) && !this.isEmpty(this.view.getUsername()) && !this.isEmpty(this.view.getPassword());
        callback.callback((Object)isValid);
    }

    public String getWizardTitle() {
        return this.view.getWizardTitle();
    }

    public void disable() {
        this.view.disable();
    }

    protected void onProviderNameChange() {
        if (!this.isEmpty(this.view.getProviderName())) {
            this.view.setProviderNameStatus(FormStatus.VALID);
        } else {
            this.view.setProviderNameStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onMainURLChange() {
        if (!this.isEmpty(this.view.getMainURL())) {
            this.view.setMainURLStatus(FormStatus.VALID);
        } else {
            this.view.setMainURLStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onUserNameChange() {
        if (!this.isEmpty(this.view.getUsername())) {
            this.view.setUsernameStatus(FormStatus.VALID);
        } else {
            this.view.setUsernameStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onPasswordChange() {
        if (!this.isEmpty(this.view.getPassword())) {
            this.view.setPasswordStatus(FormStatus.VALID);
        } else {
            this.view.setPasswordStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    private void onContentChange() {
        this.fireChangeHandlers();
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static interface View
    extends UberElement<OpenShiftProviderConfigPresenter> {
        public String getProviderName();

        public String getMainURL();

        public String getUsername();

        public String getPassword();

        public void setProviderName(String var1);

        public void setMainURL(String var1);

        public void setUsername(String var1);

        public void setPassword(String var1);

        public void disable();

        public void enable();

        public void setProviderNameStatus(FormStatus var1);

        public void setMainURLStatus(FormStatus var1);

        public void setUsernameStatus(FormStatus var1);

        public void setPasswordStatus(FormStatus var1);

        public void clear();

        public String getWizardTitle();
    }
}

