/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.pipeline.template.table;

import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.List;
import org.guvnor.ala.ui.openshift.client.pipeline.template.table.TemplateParamsTablePresenter;
import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TemplateParamsTablePresenterTest {
    private static final String OLD_VALUE = "OLD_VALUE";
    private static final String NEW_VALUE = "NEW_VALUE";
    private static final String PARAM_NAME = "PARAM_NAME";
    @Mock
    private TemplateParamsTablePresenter.View view;
    @Mock
    private ListDataProvider<TemplateParam> dataProvider;
    @Mock
    private List<TemplateParam> dataProviderList;
    @Mock
    private HasData<TemplateParam> dataDisplay;
    private TemplateParamsTablePresenter presenter;
    @Mock
    private TemplateParamsTablePresenter.ParamChangeHandler changeHandler;

    @Before
    public void setUp() {
        Mockito.when((Object)this.view.getDisplay()).thenReturn(this.dataDisplay);
        Mockito.when((Object)this.dataProvider.getList()).thenReturn(this.dataProviderList);
        this.presenter = new TemplateParamsTablePresenter(this.view){

            ListDataProvider<TemplateParam> createDataProvider() {
                return TemplateParamsTablePresenterTest.this.dataProvider;
            }
        };
        this.presenter.init();
        ((TemplateParamsTablePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ListDataProvider)Mockito.verify(this.dataProvider, (VerificationMode)Mockito.times((int)1))).addDataDisplay(this.dataDisplay);
    }

    @Test
    public void testSetItems() {
        List items = (List)Mockito.mock(List.class);
        this.presenter.setItems(items);
        ((List)Mockito.verify(this.dataProviderList, (VerificationMode)Mockito.times((int)1))).clear();
        ((List)Mockito.verify(this.dataProviderList, (VerificationMode)Mockito.times((int)1))).addAll(items);
        ((ListDataProvider)Mockito.verify(this.dataProvider, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((List)Mockito.verify(this.dataProviderList, (VerificationMode)Mockito.times((int)1))).clear();
        ((ListDataProvider)Mockito.verify(this.dataProvider, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testOnParamChange() {
        this.presenter.setParamChangeHandler(this.changeHandler);
        this.presenter.onParamChange(PARAM_NAME, NEW_VALUE, OLD_VALUE);
        ((TemplateParamsTablePresenter.ParamChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onParamChange(PARAM_NAME, NEW_VALUE, OLD_VALUE);
    }
}

