/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplHelper;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PipelineExecutorTaskManagerImplHelperTest {
    private static final int CONFIG_EXECUTORS_SIZE = 5;
    private static final int PIPELINE_EVENT_LISTENERS = 7;
    private static final int STAGES_COUNT = 7;
    @Mock
    private Instance<ConfigExecutor> configExecutorsInstance;
    @Mock
    private Instance<PipelineEventListener> eventListenersInstance;
    private List<ConfigExecutor> configExecutors;
    private List<PipelineEventListener> externalListeners;
    private PipelineExecutorTaskManagerImplHelper taskManagerHelper;

    @Before
    public void setUp() {
        this.clearDefaultProperties();
        this.configExecutors = PipelineExecutorTaskManagerImplTestBase.mockConfigExecutors(5);
        Mockito.when((Object)this.configExecutorsInstance.iterator()).thenReturn(this.configExecutors.iterator());
        this.externalListeners = PipelineExecutorTaskManagerImplTestBase.mockEventListeners(7);
        Mockito.when((Object)this.eventListenersInstance.iterator()).thenReturn(this.externalListeners.iterator());
        this.taskManagerHelper = (PipelineExecutorTaskManagerImplHelper)Mockito.spy((Object)new PipelineExecutorTaskManagerImplHelper(this.configExecutorsInstance, this.eventListenersInstance));
    }

    @Test
    public void testCreateExecutorServiceWithDefaultValue() {
        ExecutorService executorService = this.taskManagerHelper.createExecutorService();
        this.verifyExecutorServiceAndDestroy(executorService, 10);
    }

    @Test
    public void testCreateExecutorServiceWithManualValueCorrect() {
        int valueToSet = 1234;
        System.setProperty("org.guvnor.ala.pipeline.execution.threadPoolSize", Integer.toString(valueToSet));
        ExecutorService executorService = this.taskManagerHelper.createExecutorService();
        this.verifyExecutorServiceAndDestroy(executorService, valueToSet);
    }

    @Test
    public void testCreateExecutorServiceWithManualValueIncorrect() {
        String valueToSet = "an invalid integer";
        System.setProperty("org.guvnor.ala.pipeline.execution.threadPoolSize", valueToSet);
        ExecutorService executorService = this.taskManagerHelper.createExecutorService();
        this.verifyExecutorServiceAndDestroy(executorService, 10);
    }

    private void verifyExecutorServiceAndDestroy(ExecutorService executorService, int expectedSize) {
        Assert.assertNotNull((Object)executorService);
        Assert.assertTrue((boolean)(executorService instanceof ThreadPoolExecutor));
        Assert.assertEquals((long)expectedSize, (long)((ThreadPoolExecutor)executorService).getCorePoolSize());
        try {
            executorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePipelineExecutor() {
        Assert.assertNotNull((Object)this.taskManagerHelper.createPipelineExecutor());
        ((Instance)Mockito.verify(this.configExecutorsInstance, (VerificationMode)Mockito.times((int)1))).iterator();
        ((PipelineExecutorTaskManagerImplHelper)Mockito.verify((Object)this.taskManagerHelper, (VerificationMode)Mockito.times((int)1))).newPipelineExecutor(this.configExecutors);
    }

    @Test
    public void testCreateExternalListeners() {
        List result = this.taskManagerHelper.createExternalListeners();
        ((Instance)Mockito.verify(this.eventListenersInstance, (VerificationMode)Mockito.times((int)1))).iterator();
        Assert.assertEquals(this.externalListeners, (Object)result);
    }

    @Test
    public void testSetTaskInStoppedStatus() {
        List<String> scheduledStages = this.mockStages(7, "scheduled");
        List<String> runningStages = this.mockStages(7, "running");
        List<String> finishedStages = this.mockStages(7, "finished");
        List<String> errorStages = this.mockStages(7, "error");
        List<String> stoppedStages = this.mockStages(7, "stopped");
        ArrayList<String> stages = new ArrayList<String>();
        stages.addAll(scheduledStages);
        stages.addAll(runningStages);
        stages.addAll(finishedStages);
        stages.addAll(errorStages);
        stages.addAll(stoppedStages);
        PipelineExecutorTaskDef taskDef = (PipelineExecutorTaskDef)Mockito.mock(PipelineExecutorTaskDef.class);
        Input input = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)taskDef.getInput()).thenReturn((Object)input);
        Mockito.when((Object)taskDef.getStages()).thenReturn(stages);
        PipelineExecutorTaskImpl task = new PipelineExecutorTaskImpl(taskDef, "executionId");
        task.setPipelineStatus(PipelineExecutorTask.Status.RUNNING);
        this.setStagesInStatus(task, scheduledStages, PipelineExecutorTask.Status.SCHEDULED);
        this.setStagesInStatus(task, runningStages, PipelineExecutorTask.Status.RUNNING);
        this.setStagesInStatus(task, finishedStages, PipelineExecutorTask.Status.FINISHED);
        this.setStagesInStatus(task, errorStages, PipelineExecutorTask.Status.ERROR);
        this.setStagesInStatus(task, stoppedStages, PipelineExecutorTask.Status.STOPPED);
        this.taskManagerHelper.setTaskInStoppedStatus(task);
        this.assertStagesInStatus(task, scheduledStages, PipelineExecutorTask.Status.STOPPED);
        this.assertStagesInStatus(task, runningStages, PipelineExecutorTask.Status.STOPPED);
        this.assertStagesInStatus(task, finishedStages, PipelineExecutorTask.Status.FINISHED);
        this.assertStagesInStatus(task, errorStages, PipelineExecutorTask.Status.ERROR);
        this.assertStagesInStatus(task, stoppedStages, PipelineExecutorTask.Status.STOPPED);
        Assert.assertEquals((Object)PipelineExecutorTask.Status.STOPPED, (Object)task.getPipelineStatus());
    }

    private void clearDefaultProperties() {
        System.getProperties().remove("org.guvnor.ala.pipeline.execution.threadPoolSize");
    }

    private List<String> mockStages(int count, String suffix) {
        ArrayList<String> stages = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String stage = "Stage." + suffix + Integer.toString(i);
            stages.add(stage);
        }
        return stages;
    }

    private void setStagesInStatus(PipelineExecutorTaskImpl task, List<String> stages, PipelineExecutorTask.Status status) {
        stages.forEach(stage -> task.setStageStatus(stage, status));
    }

    private void assertStagesInStatus(PipelineExecutorTaskImpl task, List<String> stages, PipelineExecutorTask.Status status) {
        stages.forEach(stage -> Assert.assertEquals((Object)status, (Object)task.getStageStatus(stage)));
    }
}

