/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.util;

import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.util.VariableInterpolation;
import org.junit.Assert;
import org.junit.Test;

public class VariableInterpolationTest {
    @Test
    public void basicTest() {
        Test1 object = new Test1(){};
        Test1 newObject = (Test1)VariableInterpolation.interpolate((Map)new HashMap<String, Object>(){
            {
                this.put("input", new HashMap<String, String>(){
                    {
                        this.put("value1", "myvalue1");
                        this.put("value2", "myvalue2");
                    }
                });
            }
        }, (Object)object);
        Assert.assertEquals((Object)"myvalue1", (Object)newObject.getValue1());
        Assert.assertEquals((Object)"myvalue2", (Object)newObject.getValue2());
        Assert.assertEquals((Object)"myvalue1", (Object)newObject.getValue3());
    }

    @Test
    public void missingContentTest() {
        Test1 object = new Test1(){};
        Test1 newObject = (Test1)VariableInterpolation.interpolate((Map)new HashMap<String, Object>(){
            {
                this.put("input", new HashMap<String, String>(){
                    {
                        this.put("value2", "myvalue2");
                    }
                });
            }
        }, (Object)object);
        Assert.assertEquals((Object)"", (Object)newObject.getValue1());
        Assert.assertEquals((Object)"myvalue2", (Object)newObject.getValue2());
        Assert.assertEquals((Object)"", (Object)newObject.getValue3());
    }

    @Test
    public void testPreserveImplementedInterfaces() {
        Test1Class object = new Test1Class();
        Object newObject = VariableInterpolation.interpolate(new HashMap(), (Object)object);
        Assert.assertTrue((boolean)(newObject instanceof Test1));
        object = new Test2Class();
        newObject = VariableInterpolation.interpolate(new HashMap(), (Object)object);
        Assert.assertTrue((boolean)(newObject instanceof Test1));
        object = new Test3Class();
        newObject = VariableInterpolation.interpolate(new HashMap(), (Object)object);
        Assert.assertTrue((boolean)(newObject instanceof Test1));
    }

    public class Test3Class
    extends Test2Class {
    }

    public class Test2Class
    extends Test1Class {
    }

    public class Test1Class
    implements Test1 {
    }

    public static interface Test1 {
        default public String getValue1() {
            return "${input.value1}";
        }

        default public String getValue2() {
            return "${input.value2}";
        }

        default public String getValue3() {
            return "${input.value1}";
        }
    }
}

