/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.build.Binary;
import org.guvnor.ala.registry.inmemory.InMemoryBuildRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InMemoryBuildRegistryTest {
    private static final String BINARY_NAME = "BINARY_NAME";
    private static final int BINARIES_COUNT = 10;
    private InMemoryBuildRegistry buildRegistry;

    @Before
    public void setUp() {
        this.buildRegistry = new InMemoryBuildRegistry();
    }

    @Test
    public void registerBinary() {
        Binary binary = (Binary)Mockito.mock(Binary.class);
        Mockito.when((Object)binary.getName()).thenReturn((Object)BINARY_NAME);
        this.buildRegistry.registerBinary(binary);
        List result = this.buildRegistry.getAllBinaries();
        Assert.assertTrue((boolean)result.contains(binary));
    }

    @Test
    public void testGetAllBinaries() {
        ArrayList<Binary> binaries = new ArrayList<Binary>();
        for (int i = 0; i < 10; ++i) {
            Binary binary2 = (Binary)Mockito.mock(Binary.class);
            Mockito.when((Object)binary2.getName()).thenReturn((Object)(BINARY_NAME + Integer.toString(i)));
            binaries.add(binary2);
        }
        binaries.forEach(binary -> this.buildRegistry.registerBinary(binary));
        List result = this.buildRegistry.getAllBinaries();
        Assert.assertEquals((long)binaries.size(), (long)result.size());
        for (Binary binary3 : binaries) {
            Assert.assertTrue((boolean)result.contains(binary3));
        }
    }
}

