/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.pipeline.execution.RegistrableOutput;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineExecutorRegistry;
import org.guvnor.ala.runtime.RuntimeId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InMemoryPipelineExecutorRegistryTest {
    protected InMemoryPipelineExecutorRegistry pipelineExecutorRegistry;
    protected static final String PIPELINE_EXECUTION_ID = "PIPELINE_EXECUTION_ID";
    protected static final String RUNTIME_ID = "RUNTIME_ID";
    protected static final int TRACES_COUNT = 10;
    protected PipelineExecutorTrace trace;

    @Before
    public void setUp() {
        this.trace = (PipelineExecutorTrace)Mockito.mock(PipelineExecutorTrace.class);
        Mockito.when((Object)this.trace.getTaskId()).thenReturn((Object)PIPELINE_EXECUTION_ID);
        this.pipelineExecutorRegistry = new InMemoryPipelineExecutorRegistry();
    }

    @Test
    public void testRegister() {
        this.pipelineExecutorRegistry.register(this.trace);
        PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace(PIPELINE_EXECUTION_ID);
        Assert.assertEquals((Object)this.trace, (Object)result);
    }

    @Test
    public void testDeregister() {
        this.pipelineExecutorRegistry.register(this.trace);
        PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace(PIPELINE_EXECUTION_ID);
        Assert.assertEquals((Object)this.trace, (Object)result);
        this.pipelineExecutorRegistry.deregister(this.trace.getTaskId());
        result = this.pipelineExecutorRegistry.getExecutorTrace(PIPELINE_EXECUTION_ID);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetExecutorTrace() {
        this.pipelineExecutorRegistry.register(this.trace);
        PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace(PIPELINE_EXECUTION_ID);
        Assert.assertEquals((Object)this.trace, (Object)result);
    }

    @Test
    public void testGetExecutorTraces() {
        ArrayList<PipelineExecutorTrace> traces = new ArrayList<PipelineExecutorTrace>();
        for (int i = 0; i < 10; ++i) {
            PipelineExecutorTrace trace2 = (PipelineExecutorTrace)Mockito.mock(PipelineExecutorTrace.class);
            Mockito.when((Object)trace2.getTaskId()).thenReturn((Object)(PIPELINE_EXECUTION_ID + Integer.toString(i)));
            traces.add(trace2);
        }
        traces.forEach(trace -> this.pipelineExecutorRegistry.register(trace));
        Collection result = this.pipelineExecutorRegistry.getExecutorTraces();
        Assert.assertEquals((long)traces.size(), (long)result.size());
        for (PipelineExecutorTrace trace3 : traces) {
            Assert.assertTrue((boolean)result.contains(trace3));
        }
    }

    @Test
    public void getExecutorTraceByRuntimeId() {
        RuntimeIdMock runtimeId = (RuntimeIdMock)Mockito.mock(RuntimeIdMock.class);
        Mockito.when((Object)runtimeId.getId()).thenReturn((Object)RUNTIME_ID);
        PipelineExecutorTask task = (PipelineExecutorTask)Mockito.mock(PipelineExecutorTask.class);
        Mockito.when((Object)task.getOutput()).thenReturn((Object)runtimeId);
        Mockito.when((Object)this.trace.getTask()).thenReturn((Object)task);
        this.pipelineExecutorRegistry.register(this.trace);
        PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace((RuntimeId)runtimeId);
        Assert.assertEquals((Object)this.trace, (Object)result);
    }

    private static interface RuntimeIdMock
    extends RuntimeId,
    RegistrableOutput {
    }
}

