/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.events.AfterPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.AfterStageExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforePipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforeStageExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorStageExecutionEvent;
import org.guvnor.ala.pipeline.events.PipelineEvent;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutorError;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplTestBase;
import org.guvnor.ala.registry.PipelineExecutorRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PipelineExecutorTaskManagerImplEventsTest
extends PipelineExecutorTaskManagerImplTestBase {
    private PipelineExecutorTaskImpl task;
    private PipelineExecutorTaskManagerImpl.TaskEntry taskEntry;
    private Stage stage;
    private Throwable error;
    protected ArgumentCaptor<PipelineExecutorError> pipelineExecutorErrorCaptor;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.error = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)this.error.getMessage()).thenReturn((Object)"ERROR_MESSAGE");
        this.pipelineExecutorErrorCaptor = ArgumentCaptor.forClass(PipelineExecutorError.class);
        this.pipeline = (Pipeline)Mockito.mock(Pipeline.class);
        this.stages = PipelineExecutorTaskManagerImplEventsTest.mockStages(6);
        Mockito.when((Object)this.pipeline.getStages()).thenReturn((Object)this.stages);
        Mockito.when((Object)this.pipeline.getName()).thenReturn((Object)"PIPELINE_ID");
        Mockito.when((Object)this.pipelineRegistry.getPipelineByName("PIPELINE_ID")).thenReturn((Object)this.pipeline);
        this.stage = (Stage)this.stages.get(0);
        this.taskDef = (PipelineExecutorTaskDef)Mockito.mock(PipelineExecutorTaskDef.class);
        this.input = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)this.taskDef.getInput()).thenReturn((Object)this.input);
        Mockito.when((Object)this.taskDef.getPipeline()).thenReturn((Object)"PIPELINE_ID");
        this.task = (PipelineExecutorTaskImpl)Mockito.spy((Object)this.taskManagerHelper.createTask(this.taskDef, "TASK_ID"));
        this.taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)Mockito.mock(PipelineExecutorTaskManagerImpl.TaskEntry.class);
        Mockito.when((Object)this.taskEntry.getTask()).thenReturn((Object)this.task);
        this.taskManager.currentTasks.put("TASK_ID", this.taskEntry);
        this.taskManager.init();
    }

    @Test
    public void testBeforePipelineExecutionEventForAsyncTask() {
        this.testBeforePipelineExecutionEvent(true);
    }

    @Test
    public void testBeforePipelineExecutionEventForSyncTask() {
        this.testBeforePipelineExecutionEvent(false);
    }

    private void testBeforePipelineExecutionEvent(boolean async) {
        Mockito.when((Object)this.taskEntry.isAsync()).thenReturn((Object)async);
        BeforePipelineExecutionEvent event = new BeforePipelineExecutionEvent("TASK_ID", this.pipeline);
        this.taskManager.localListener.beforePipelineExecution(event);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setPipelineStatus(PipelineExecutorTask.Status.RUNNING);
        this.verifyExecutorRegistryUpdated(async);
        this.verifyExternalListenersNotified((PipelineEvent)event);
    }

    @Test
    public void testAfterPipelineExecutionEventForAsyncTask() {
        this.testAfterPipelineExecutionEvent(true);
    }

    @Test
    public void testAfterPipelineExecutionEventForSyncTask() {
        this.testAfterPipelineExecutionEvent(true);
    }

    private void testAfterPipelineExecutionEvent(boolean async) {
        Mockito.when((Object)this.taskEntry.isAsync()).thenReturn((Object)async);
        AfterPipelineExecutionEvent event = new AfterPipelineExecutionEvent("TASK_ID", this.pipeline);
        this.taskManager.localListener.afterPipelineExecution(event);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setPipelineStatus(PipelineExecutorTask.Status.FINISHED);
        this.verifyExecutorRegistryUpdated(async);
        this.verifyExternalListenersNotified((PipelineEvent)event);
    }

    @Test
    public void testBeforeStageExecutionEventForAsyncTask() {
        this.testBeforeStageExecutionEvent(true);
    }

    @Test
    public void testBeforeStageExecutionEventForSyncTask() {
        this.testBeforeStageExecutionEvent(false);
    }

    private void testBeforeStageExecutionEvent(boolean async) {
        Mockito.when((Object)this.taskEntry.isAsync()).thenReturn((Object)async);
        BeforeStageExecutionEvent event = new BeforeStageExecutionEvent("TASK_ID", this.pipeline, this.stage);
        this.taskManager.localListener.beforeStageExecution(event);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setStageStatus(this.stage.getName(), PipelineExecutorTask.Status.RUNNING);
        this.verifyExecutorRegistryUpdated(async);
        this.verifyExternalListenersNotified((PipelineEvent)event);
    }

    @Test
    public void testOnStageErrorExecutionEventForAsyncTask() {
        this.testOnStageErrorExecutionEvent(true);
    }

    @Test
    public void testOnStageErrorExecutionEventForSyncTask() {
        this.testOnStageErrorExecutionEvent(false);
    }

    private void testOnStageErrorExecutionEvent(boolean async) {
        Mockito.when((Object)this.taskEntry.isAsync()).thenReturn((Object)async);
        OnErrorStageExecutionEvent event = new OnErrorStageExecutionEvent("TASK_ID", this.pipeline, this.stage, this.error);
        this.taskManager.localListener.onStageError(event);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setPipelineStatus(PipelineExecutorTask.Status.ERROR);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setStageStatus(this.stage.getName(), PipelineExecutorTask.Status.ERROR);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setStageError((String)Mockito.eq((Object)this.stage.getName()), (PipelineExecutorError)this.pipelineExecutorErrorCaptor.capture());
        Assert.assertEquals((Object)new PipelineExecutorError("ERROR_MESSAGE", this.error), (Object)this.pipelineExecutorErrorCaptor.getValue());
        this.verifyExecutorRegistryUpdated(async);
        this.verifyExternalListenersNotified((PipelineEvent)event);
    }

    @Test
    public void testAfterStageExecutionEventForAsyncTask() {
        this.testAfterStageExecutionEvent(true);
    }

    @Test
    public void testAfterStageExecutionEventForSyncTask() {
        this.testAfterStageExecutionEvent(false);
    }

    private void testAfterStageExecutionEvent(boolean async) {
        Mockito.when((Object)this.taskEntry.isAsync()).thenReturn((Object)async);
        AfterStageExecutionEvent event = new AfterStageExecutionEvent("TASK_ID", this.pipeline, this.stage);
        this.taskManager.localListener.afterStageExecution(event);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setStageStatus(this.stage.getName(), PipelineExecutorTask.Status.FINISHED);
        this.verifyExecutorRegistryUpdated(async);
        this.verifyExternalListenersNotified((PipelineEvent)event);
    }

    @Test
    public void testOnPipelineErrorExecutionEventForAsyncTask() {
        this.testOnPipelineErrorExecutionEvent(true);
    }

    @Test
    public void testOnPipelineErrorExecutionEventForSyncTask() {
        this.testOnPipelineErrorExecutionEvent(false);
    }

    private void testOnPipelineErrorExecutionEvent(boolean async) {
        Mockito.when((Object)this.taskEntry.isAsync()).thenReturn((Object)async);
        OnErrorPipelineExecutionEvent event = new OnErrorPipelineExecutionEvent("TASK_ID", this.pipeline, this.stage, this.error);
        this.taskManager.localListener.onPipelineError(event);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setPipelineStatus(PipelineExecutorTask.Status.ERROR);
        ((PipelineExecutorTaskImpl)Mockito.verify((Object)this.task, (VerificationMode)Mockito.times((int)1))).setPipelineError((PipelineExecutorError)this.pipelineExecutorErrorCaptor.capture());
        Assert.assertEquals((Object)new PipelineExecutorError("ERROR_MESSAGE", this.error), (Object)this.pipelineExecutorErrorCaptor.getValue());
        this.verifyExecutorRegistryUpdated(async);
        this.verifyExternalListenersNotified((PipelineEvent)event);
    }

    private void verifyExecutorRegistryUpdated(boolean async) {
        if (async) {
            ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)1))).register((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.capture());
            this.assertHasSameInfo((PipelineExecutorTask)this.task, ((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getTask());
        } else {
            ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.never())).register((PipelineExecutorTrace)Matchers.anyObject());
        }
    }

    private void verifyExternalListenersNotified(PipelineEvent event) {
        if (event instanceof BeforePipelineExecutionEvent) {
            this.externalListeners.forEach(listener -> ((PipelineEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).beforePipelineExecution((BeforePipelineExecutionEvent)event));
        } else if (event instanceof BeforeStageExecutionEvent) {
            this.externalListeners.forEach(listener -> ((PipelineEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).beforeStageExecution((BeforeStageExecutionEvent)event));
        } else if (event instanceof AfterStageExecutionEvent) {
            this.externalListeners.forEach(listener -> ((PipelineEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).afterStageExecution((AfterStageExecutionEvent)event));
        } else if (event instanceof AfterPipelineExecutionEvent) {
            this.externalListeners.forEach(listener -> ((PipelineEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).afterPipelineExecution((AfterPipelineExecutionEvent)event));
        } else if (event instanceof OnErrorPipelineExecutionEvent) {
            this.externalListeners.forEach(listener -> ((PipelineEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onPipelineError((OnErrorPipelineExecutionEvent)event));
        } else if (event instanceof OnErrorStageExecutionEvent) {
            this.externalListeners.forEach(listener -> ((PipelineEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onStageError((OnErrorStageExecutionEvent)event));
        }
    }
}

