/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.marshalling;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.marshalling.BaseMarshallerTest;
import org.guvnor.ala.marshalling.Marshaller;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.execution.PipelineExecutorError;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.RegistrableOutput;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskDefImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTraceImpl;
import org.guvnor.ala.pipeline.execution.marshalling.PipelineExecutorTraceImplMarshaller;
import org.guvnor.ala.pipeline.impl.BasePipeline;
import org.junit.Assert;
import org.mockito.Mockito;

public class PipelineExecutorTraceImplMarshallerTest
extends BaseMarshallerTest<PipelineExecutorTraceImpl> {
    private static final int STAGE_COUNT = 10;
    private static final int PIPELINE_INPUT_SIZE = 5;
    private static final String PIPELINE_NAME = "PIPELINE_NAME";
    private static final String PIPELINE_EXECUTION_ID = "PIPELINE_EXECUTION_ID";
    private static final String PIPELINE_ERROR = "PIPELINE_ERROR";
    private static final String PIPELINE_ERROR_DETAIL = "PIPELINE_ERROR_DETAIL";
    private static final String STAGE_ERROR = "STAGE_ERROR";
    private static final String STAGE_ERROR_DETAIL = "STAGE_ERROR_DETAIL";
    private static final String PIPELINE_OUTPUT = "PIPELINE_OUTPUT";

    @Override
    public Marshaller<PipelineExecutorTraceImpl> createMarshaller() {
        return new PipelineExecutorTraceImplMarshaller();
    }

    @Override
    public Class<PipelineExecutorTraceImpl> getType() {
        return PipelineExecutorTraceImpl.class;
    }

    @Override
    public PipelineExecutorTraceImpl getValue() {
        List<Stage> stages = this.mockStages(10);
        BasePipeline pipeline = new BasePipeline(PIPELINE_NAME, stages){};
        Input input = this.mockInput(5);
        PipelineExecutorTaskDefImpl taskDef = new PipelineExecutorTaskDefImpl((Pipeline)pipeline, input);
        PipelineExecutorTaskImpl taskImpl = new PipelineExecutorTaskImpl((PipelineExecutorTaskDef)taskDef, PIPELINE_EXECUTION_ID);
        taskImpl.setPipelineStatus(PipelineExecutorTask.Status.SCHEDULED);
        taskImpl.setPipelineError(this.mockError(PIPELINE_ERROR, PIPELINE_ERROR_DETAIL));
        taskImpl.getTaskDef().getStages().forEach(stage -> taskImpl.setStageError(stage, this.mockStageError((String)stage)));
        taskImpl.setOutput((RegistrableOutput)new MockPipelineOutput(PIPELINE_OUTPUT));
        return new PipelineExecutorTraceImpl((PipelineExecutorTask)taskImpl);
    }

    @Override
    public void testUnMarshall() throws Exception {
        PipelineExecutorTraceImpl result = (PipelineExecutorTraceImpl)this.marshaller.unmarshal(this.getMarshalledValue());
        PipelineExecutorTraceImpl expectedValue = this.getValue();
        this.assertEqualsPipelineExecutorTrace(expectedValue, result);
    }

    private void assertEqualsPipelineExecutorTrace(PipelineExecutorTraceImpl expectedValue, PipelineExecutorTraceImpl value) {
        Assert.assertEquals((Object)expectedValue.getTaskId(), (Object)value.getTaskId());
        Assert.assertEquals((Object)expectedValue.getPipelineId(), (Object)value.getPipelineId());
        Assert.assertEquals((Object)expectedValue.getTask().getTaskDef(), (Object)value.getTask().getTaskDef());
        Assert.assertEquals((Object)expectedValue.getTask().getPipelineStatus(), (Object)value.getTask().getPipelineStatus());
        Assert.assertEquals((Object)expectedValue.getTask().getPipelineError(), (Object)value.getTask().getPipelineError());
        for (String stage : expectedValue.getTask().getTaskDef().getStages()) {
            Assert.assertEquals((Object)expectedValue.getTask().getStageStatus(stage), (Object)value.getTask().getStageStatus(stage));
            Assert.assertEquals((Object)expectedValue.getTask().getStageError(stage), (Object)value.getTask().getStageError(stage));
        }
        Assert.assertEquals((Object)expectedValue.getTask().getOutput(), (Object)value.getTask().getOutput());
    }

    private List<Stage> mockStages(int count) {
        ArrayList<Stage> stages = new ArrayList<Stage>();
        for (int i = 0; i < count; ++i) {
            Stage stage = (Stage)Mockito.mock(Stage.class);
            Mockito.when((Object)stage.getName()).thenReturn((Object)("Stage.name." + Integer.toString(i)));
            stages.add(stage);
        }
        return stages;
    }

    private Input mockInput(int count) {
        Input input = new Input();
        for (int i = 0; i < count; ++i) {
            input.put((Object)("key." + Integer.toString(i)), (Object)("value." + Integer.toString(i)));
        }
        return input;
    }

    private PipelineExecutorError mockStageError(String stage) {
        return this.mockError(this.buildStageErrorMessage(stage), this.buildStageErrorDetail(stage));
    }

    private PipelineExecutorError mockError(String error, String detail) {
        return new PipelineExecutorError(error, detail);
    }

    private String buildStageErrorMessage(String stage) {
        return stage + "." + STAGE_ERROR;
    }

    private String buildStageErrorDetail(String stage) {
        return stage + "." + STAGE_ERROR_DETAIL;
    }

    public static class MockPipelineOutput
    implements RegistrableOutput {
        private String outputValue;

        public MockPipelineOutput() {
        }

        public MockPipelineOutput(String outputValue) {
            this.outputValue = outputValue;
        }

        public String getOutputValue() {
            return this.outputValue;
        }

        public void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockPipelineOutput that = (MockPipelineOutput)o;
            return this.outputValue != null ? this.outputValue.equals(that.outputValue) : that.outputValue == null;
        }

        public int hashCode() {
            return this.outputValue != null ? this.outputValue.hashCode() : 0;
        }
    }
}

