/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.pipeline.execution.PipelineExecutorException;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskManager;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplHelper;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplTestBase;
import org.guvnor.ala.registry.PipelineExecutorRegistry;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.matchers.StartsWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PipelineExecutorTaskManagerImplExecutionTest
extends PipelineExecutorTaskManagerImplTestBase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Test
    public void testExecuteAsync() {
        Mockito.when((Object)this.taskManagerHelper.generateTaskId()).thenReturn((Object)"TASK_ID");
        this.taskManager.init();
        this.prepareExecution();
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when(this.executorService.submit((Runnable)ArgumentMatchers.any(Runnable.class))).thenReturn((Object)future);
        String result = this.taskManager.execute(this.taskDef, PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS);
        Assert.assertEquals((Object)"TASK_ID", (Object)result);
        PipelineExecutorTaskManagerImpl.TaskEntry internalTaskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)this.taskManager.currentTasks.get("TASK_ID");
        this.verifyInternalTask(internalTaskEntry, true);
        Assert.assertEquals((long)1L, (long)this.taskManager.currentTasks.size());
        ((ExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
        Assert.assertEquals((Object)future, this.taskManager.futureTaskMap.get("TASK_ID"));
        ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)1))).register((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.capture());
        Assert.assertEquals((Object)"PIPELINE_ID", (Object)((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getPipelineId());
        Assert.assertEquals((Object)"TASK_ID", (Object)((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getTaskId());
        this.assertHasSameInfo((PipelineExecutorTask)internalTaskEntry.getTask(), ((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getTask());
    }

    @Test
    public void testExecuteSync() {
        Mockito.when((Object)this.taskManagerHelper.generateTaskId()).thenReturn((Object)"TASK_ID");
        this.taskManager.init();
        this.prepareExecution();
        String result = this.taskManager.execute(this.taskDef, PipelineExecutorTaskManager.ExecutionMode.SYNCHRONOUS);
        Assert.assertEquals((Object)"TASK_ID", (Object)result);
        ((PipelineExecutorTaskManagerImplHelper)Mockito.verify((Object)this.taskManagerHelper, (VerificationMode)Mockito.times((int)1))).createTask(this.taskDef);
        ((PipelineExecutor)Mockito.verify((Object)this.pipelineExecutor, (VerificationMode)Mockito.times((int)1))).execute((Input)ArgumentMatchers.eq((Object)this.taskDef.getInput()), (Pipeline)ArgumentMatchers.eq((Object)this.pipeline), (Consumer)ArgumentMatchers.any(Consumer.class), new PipelineEventListener[]{(PipelineEventListener)ArgumentMatchers.eq((Object)this.taskManager.localListener)});
        ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)1))).register((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.capture());
        Assert.assertEquals((Object)"PIPELINE_ID", (Object)((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getPipelineId());
        Assert.assertEquals((Object)"TASK_ID", (Object)((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getTaskId());
    }

    @Test
    public void testStopNonExistingTask() throws PipelineExecutorException {
        this.taskManager.init();
        this.expectedException.expectMessage("No PipelineExecutorTask was found for taskId: TASK_ID");
        this.taskManager.stop("TASK_ID");
    }

    @Test
    public void testStopSyncTask() throws PipelineExecutorException {
        PipelineExecutorTaskManagerImpl.TaskEntry taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)Mockito.mock(PipelineExecutorTaskManagerImpl.TaskEntry.class);
        Mockito.when((Object)taskEntry.isAsync()).thenReturn((Object)false);
        this.taskManager.currentTasks.put("TASK_ID", taskEntry);
        this.taskManager.init();
        this.expectedException.expectMessage("Stop operation is not available for taskId: TASK_ID running in SYNCHRONOUS mode");
        this.taskManager.stop("TASK_ID");
    }

    @Test
    public void testStopAsyncTask() throws PipelineExecutorException {
        Mockito.when((Object)this.taskManagerHelper.generateTaskId()).thenReturn((Object)"TASK_ID");
        this.taskManager.init();
        this.prepareExecution();
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when(this.executorService.submit((Runnable)ArgumentMatchers.any(Runnable.class))).thenReturn((Object)future);
        String result = this.taskManager.execute(this.taskDef, PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS);
        Assert.assertEquals((Object)"TASK_ID", (Object)result);
        PipelineExecutorTaskManagerImpl.TaskEntry taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)this.taskManager.currentTasks.get("TASK_ID");
        this.taskManager.stop("TASK_ID");
        ((Future)Mockito.verify((Object)future, (VerificationMode)Mockito.times((int)1))).cancel(true);
        Assert.assertFalse((boolean)this.taskManager.currentTasks.containsKey("TASK_ID"));
        ((PipelineExecutorTaskManagerImplHelper)Mockito.verify((Object)this.taskManagerHelper, (VerificationMode)Mockito.times((int)1))).setTaskInStoppedStatus(taskEntry.getTask());
        ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)2))).register((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.capture());
        this.assertHasSameInfo(((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getAllValues().get(1)).getTask(), ((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.getValue()).getTask());
    }

    @Test
    public void testStopTaskInErrorStatus() throws PipelineExecutorException {
        this.testStopTaskInNonStopeableState(PipelineExecutorTask.Status.ERROR);
    }

    @Test
    public void testStopTaskInStoppedStatus() throws PipelineExecutorException {
        this.testStopTaskInNonStopeableState(PipelineExecutorTask.Status.STOPPED);
    }

    @Test
    public void testStopTaskInFinishedStatus() throws PipelineExecutorException {
        this.testStopTaskInNonStopeableState(PipelineExecutorTask.Status.FINISHED);
    }

    private void testStopTaskInNonStopeableState(final PipelineExecutorTask.Status notStopeableStatus) throws PipelineExecutorException {
        PipelineExecutorTaskImpl task = (PipelineExecutorTaskImpl)Mockito.mock(PipelineExecutorTaskImpl.class);
        Mockito.when((Object)task.getId()).thenReturn((Object)"TASK_ID");
        Mockito.when((Object)task.getPipelineStatus()).thenReturn((Object)notStopeableStatus);
        PipelineExecutorTaskManagerImpl.TaskEntry taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)Mockito.mock(PipelineExecutorTaskManagerImpl.TaskEntry.class);
        Mockito.when((Object)taskEntry.isAsync()).thenReturn((Object)true);
        Mockito.when((Object)taskEntry.getTask()).thenReturn((Object)task);
        this.taskManager.currentTasks.put("TASK_ID", taskEntry);
        this.taskManager.init();
        this.expectedException.expectMessage((Matcher)new BaseMatcher<String>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object item) {
                return item instanceof String && new StartsWith("A PipelineExecutorTask in status: " + notStopeableStatus.name() + " can not be stopped. Stop operation is available for the following status set:").matches((String)item);
            }
        });
        this.taskManager.stop("TASK_ID");
    }

    @Test
    public void testDestroyNonExistingTask() throws PipelineExecutorException {
        this.taskManager.init();
        this.expectedException.expectMessage("No PipelineExecutorTask was found for taskId: TASK_ID");
        this.taskManager.destroy("TASK_ID");
    }

    @Test
    public void testDestroySyncTask() throws PipelineExecutorException {
        PipelineExecutorTaskManagerImpl.TaskEntry taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)Mockito.mock(PipelineExecutorTaskManagerImpl.TaskEntry.class);
        Mockito.when((Object)taskEntry.isAsync()).thenReturn((Object)false);
        this.taskManager.currentTasks.put("TASK_ID", taskEntry);
        this.taskManager.init();
        this.expectedException.expectMessage("Destroy operation is not available for taskId: TASK_ID running in SYNCHRONOUS mode");
        this.taskManager.destroy("TASK_ID");
    }

    @Test
    public void testDestroyAsyncTask() throws PipelineExecutorException {
        Mockito.when((Object)this.taskManagerHelper.generateTaskId()).thenReturn((Object)"TASK_ID");
        this.taskManager.init();
        this.prepareExecution();
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when(this.executorService.submit((Runnable)ArgumentMatchers.any(Runnable.class))).thenReturn((Object)future);
        String result = this.taskManager.execute(this.taskDef, PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS);
        Assert.assertEquals((Object)"TASK_ID", (Object)result);
        this.taskManager.destroy("TASK_ID");
        ((Future)Mockito.verify((Object)future, (VerificationMode)Mockito.times((int)1))).cancel(true);
        Assert.assertFalse((boolean)this.taskManager.currentTasks.containsKey("TASK_ID"));
        ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)1))).deregister("TASK_ID");
    }

    @Test
    public void testDeleteActiveTask() throws Exception {
        PipelineExecutorTaskManagerImpl.TaskEntry taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)Mockito.mock(PipelineExecutorTaskManagerImpl.TaskEntry.class);
        this.taskManager.currentTasks.put("TASK_ID", taskEntry);
        this.expectedException.expectMessage((Matcher)new BaseMatcher<String>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object item) {
                return item instanceof String && new StartsWith("An active PipelineExecutorTask was found for taskId: TASK_ID").matches((String)item);
            }
        });
        this.taskManager.delete("TASK_ID");
    }

    @Test
    public void testDeleteTaskInScheduledStatus() throws Exception {
        this.testDeleteTaskInNonStopeableState(PipelineExecutorTask.Status.SCHEDULED);
    }

    @Test
    public void testDeleteTaskInRunningStatus() throws Exception {
        this.testDeleteTaskInNonStopeableState(PipelineExecutorTask.Status.RUNNING);
    }

    private void testDeleteTaskInNonStopeableState(final PipelineExecutorTask.Status nonStopeableStatus) throws Exception {
        PipelineExecutorTask task = (PipelineExecutorTask)Mockito.mock(PipelineExecutorTask.class);
        Mockito.when((Object)task.getPipelineStatus()).thenReturn((Object)nonStopeableStatus);
        PipelineExecutorTrace trace = (PipelineExecutorTrace)Mockito.mock(PipelineExecutorTrace.class);
        Mockito.when((Object)trace.getTask()).thenReturn((Object)task);
        Mockito.when((Object)this.pipelineExecutorRegistry.getExecutorTrace("TASK_ID")).thenReturn((Object)trace);
        this.expectedException.expectMessage((Matcher)new BaseMatcher<String>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object item) {
                return item instanceof String && new StartsWith("A PipelineExecutorTask in status: " + nonStopeableStatus + " can not be deleted. Delete operation is available for the following status set:").matches((String)item);
            }
        });
        this.taskManager.delete("TASK_ID");
    }

    @Test
    public void testDeleteNonExistingTask() throws Exception {
        this.expectedException.expectMessage("No PipelineExecutorTask was found for taskId: TASK_ID");
        this.taskManager.delete("TASK_ID");
    }

    @Test
    public void testDeleteTask() throws Exception {
        PipelineExecutorTrace trace = (PipelineExecutorTrace)Mockito.mock(PipelineExecutorTrace.class);
        PipelineExecutorTask task = (PipelineExecutorTask)Mockito.mock(PipelineExecutorTask.class);
        PipelineExecutorTask.Status status = PipelineExecutorTask.Status.STOPPED;
        Mockito.when((Object)task.getPipelineStatus()).thenReturn((Object)status);
        Mockito.when((Object)trace.getTask()).thenReturn((Object)task);
        Mockito.when((Object)this.pipelineExecutorRegistry.getExecutorTrace("TASK_ID")).thenReturn((Object)trace);
        this.taskManager.delete("TASK_ID");
        ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)1))).deregister("TASK_ID");
    }

    @Test
    public void testDestroy() throws Exception {
        int runningTasks = 5;
        ArrayList<PipelineExecutorTaskImpl> tasks = new ArrayList<PipelineExecutorTaskImpl>();
        for (int i = 0; i < runningTasks; ++i) {
            String taskId = "TASK_ID" + i;
            PipelineExecutorTaskImpl task2 = (PipelineExecutorTaskImpl)Mockito.mock(PipelineExecutorTaskImpl.class);
            Mockito.when((Object)task2.clone()).thenReturn((Object)task2);
            Mockito.when((Object)task2.getId()).thenReturn((Object)taskId);
            Mockito.when((Object)task2.getPipelineStatus()).thenReturn((Object)PipelineExecutorTask.Status.RUNNING);
            PipelineExecutorTaskDef taskDef = (PipelineExecutorTaskDef)Mockito.mock(PipelineExecutorTaskDef.class);
            Mockito.when((Object)task2.getTaskDef()).thenReturn((Object)taskDef);
            Pipeline pipeline = (Pipeline)Mockito.mock(Pipeline.class);
            Mockito.when((Object)pipeline.getStages()).thenReturn((Object)((List)Mockito.mock(List.class)));
            Mockito.when((Object)taskDef.getPipeline()).thenReturn((Object)"PIPELINE_ID");
            PipelineExecutorTaskManagerImpl.TaskEntry taskEntry = (PipelineExecutorTaskManagerImpl.TaskEntry)Mockito.mock(PipelineExecutorTaskManagerImpl.TaskEntry.class);
            Mockito.when((Object)taskEntry.isAsync()).thenReturn((Object)true);
            Mockito.when((Object)taskEntry.getTask()).thenReturn((Object)task2);
            this.taskManager.currentTasks.put(taskId, taskEntry);
            tasks.add(task2);
        }
        this.taskManager.destroy();
        tasks.forEach(task -> ((PipelineExecutorTaskManagerImplHelper)Mockito.verify((Object)this.taskManagerHelper, (VerificationMode)Mockito.times((int)1))).setTaskInStoppedStatus(task));
        ((PipelineExecutorRegistry)Mockito.verify((Object)this.pipelineExecutorRegistry, (VerificationMode)Mockito.times((int)5))).register((PipelineExecutorTrace)this.pipelineExecutorTraceCaptor.capture());
        HashMap registeredTasks = new HashMap();
        this.pipelineExecutorTraceCaptor.getAllValues().forEach(capture -> registeredTasks.put(capture.getTaskId(), capture.getTask()));
        tasks.forEach(task -> this.assertHasSameInfo((PipelineExecutorTask)task, (PipelineExecutorTask)registeredTasks.get(task.getId())));
    }

    private void prepareExecution() {
        this.pipeline = (Pipeline)Mockito.mock(Pipeline.class);
        this.stages = PipelineExecutorTaskManagerImplExecutionTest.mockStages(6);
        Mockito.when((Object)this.pipeline.getStages()).thenReturn((Object)this.stages);
        Mockito.when((Object)this.pipeline.getName()).thenReturn((Object)"PIPELINE_ID");
        Mockito.when((Object)this.pipelineRegistry.getPipelineByName("PIPELINE_ID")).thenReturn((Object)this.pipeline);
        this.taskDef = (PipelineExecutorTaskDef)Mockito.mock(PipelineExecutorTaskDef.class);
        this.input = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)this.taskDef.getInput()).thenReturn((Object)this.input);
        Mockito.when((Object)this.taskDef.getPipeline()).thenReturn((Object)"PIPELINE_ID");
    }

    private void verifyInternalTask(PipelineExecutorTaskManagerImpl.TaskEntry taskEntry, boolean isAsync) {
        Assert.assertNotNull((Object)taskEntry);
        Assert.assertEquals((Object)"TASK_ID", (Object)taskEntry.getTask().getId());
        Assert.assertEquals((Object)this.taskDef, (Object)taskEntry.getTask().getTaskDef());
        Assert.assertEquals((Object)isAsync, (Object)taskEntry.isAsync());
    }
}

