/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.ConfigBasedPipeline;
import org.guvnor.ala.pipeline.ConfigBasedPipelineBuilder;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.PipelineConfigStage;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.impl.PipelineConfigImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipelineFactoryTest {
    private static final String PIPELINE_NAME = "PIPELINE_NAME";
    private static final int CONFIG_COUNT = 10;
    private static final String CONFIG_STAGE_PREFIX = "ConfigStage";
    private List<Config> configs;

    @Before
    public void setUp() {
        this.configs = AlaSPITestCommons.mockList(Config.class, 10);
    }

    @Test
    public void testNewBuilder() {
        ConfigBasedPipelineBuilder builder = PipelineFactory.newBuilder();
        for (int i = 0; i < 10; ++i) {
            builder.addConfigStage(this.mockConfigStageName(i), this.configs.get(i));
        }
        ConfigBasedPipeline result = builder.buildAs(PIPELINE_NAME);
        this.assertPipelineIsTheExpected(result);
    }

    @Test
    public void testNewPipeline() {
        ArrayList<PipelineConfigStage> configStages = new ArrayList<PipelineConfigStage>();
        for (int i = 0; i < 10; ++i) {
            configStages.add(new PipelineConfigStage(this.mockConfigStageName(i), this.configs.get(i)));
        }
        PipelineConfigImpl pipelineConfig = new PipelineConfigImpl(PIPELINE_NAME, configStages);
        ConfigBasedPipeline result = PipelineFactory.newPipeline((PipelineConfig)pipelineConfig);
        this.assertPipelineIsTheExpected(result);
    }

    private void assertPipelineIsTheExpected(ConfigBasedPipeline pipeline) {
        Assert.assertEquals((Object)PIPELINE_NAME, (Object)pipeline.getName());
        Assert.assertNotNull((Object)pipeline.getConfig());
        PipelineConfig pipelineConfig = pipeline.getConfig();
        Assert.assertEquals((Object)PIPELINE_NAME, (Object)pipelineConfig.getName());
        List configStages = pipelineConfig.getConfigStages();
        Assert.assertEquals((long)10L, (long)configStages.size());
        for (int i = 0; i < 10; ++i) {
            PipelineConfigStage configStage = (PipelineConfigStage)configStages.get(i);
            Assert.assertEquals((Object)this.mockConfigStageName(i), (Object)configStage.getName());
            Assert.assertEquals((Object)this.configs.get(i), (Object)configStage.getConfig());
        }
    }

    private String mockConfigStageName(int i) {
        return CONFIG_STAGE_PREFIX + i;
    }
}

