/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.mockito.Mockito;

public class AlaSPITestCommons {
    public static final String PROVIDER_TYPE_NAME_FIELD = "ProviderType.providerTypeName.";
    public static final String PROVIDER_TYPE_VERSION_FIELD = "ProviderType.version.";
    public static final String PROVIDER_ID_FIELD = "Provider.id.";

    public static ProviderType mockProviderTypeSPI(final String suffix) {
        return new ProviderType(){

            public String getProviderTypeName() {
                return AlaSPITestCommons.PROVIDER_TYPE_NAME_FIELD + suffix;
            }

            public String getVersion() {
                return AlaSPITestCommons.PROVIDER_TYPE_VERSION_FIELD + suffix;
            }
        };
    }

    public static Provider mockProviderSPI(final ProviderType providerType, final String suffix) {
        return new Provider(){

            public String getId() {
                return AlaSPITestCommons.PROVIDER_ID_FIELD + suffix;
            }

            public ProviderType getProviderType() {
                return providerType;
            }

            public ProviderConfig getConfig() {
                return null;
            }
        };
    }

    public static List<ProviderType> mockProviderTypeListSPI(int count) {
        ArrayList<ProviderType> providerTypes = new ArrayList<ProviderType>();
        for (int i = 0; i < count; ++i) {
            providerTypes.add(AlaSPITestCommons.mockProviderTypeSPI(Integer.toString(i)));
        }
        return providerTypes;
    }

    public static List<Provider> mockProviderListSPI(ProviderType providerType, int count) {
        return AlaSPITestCommons.mockProviderListSPI(providerType, "", count);
    }

    public static List<Provider> mockProviderListSPI(ProviderType providerType, String suffix, int count) {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (int i = 0; i < count; ++i) {
            providers.add(AlaSPITestCommons.mockProviderSPI(providerType, Integer.toString(i) + suffix));
        }
        return providers;
    }

    public static <T> List<T> mockList(Class<T> clazz, int count) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            result.add(Mockito.mock(clazz));
        }
        return result;
    }
}

