/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineRegistry;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InMemoryPipelineRegistryTest {
    protected static final int ELEMENTS_COUNT = 10;
    protected static final String PIPELINE_ID = "PIPELINE_ID";
    protected InMemoryPipelineRegistry pipelineRegistry;
    @Mock
    protected Pipeline pipeline;
    protected ProviderType providerType;

    @Before
    public void setUp() {
        Mockito.when((Object)this.pipeline.getName()).thenReturn((Object)PIPELINE_ID);
        this.providerType = AlaSPITestCommons.mockProviderTypeSPI("");
        this.pipelineRegistry = new InMemoryPipelineRegistry();
    }

    @Test
    public void testRegisterPipeline() {
        this.verifyPipelineIsNotRegistered(this.pipeline);
        this.pipelineRegistry.registerPipeline(this.pipeline);
        this.verifyPipelineIsRegistered(this.pipeline);
    }

    @Test
    public void testRegisterPipelineForProviderType() {
        this.verifyPipelineIsNotRegistered(this.pipeline);
        this.pipelineRegistry.registerPipeline(this.pipeline, this.providerType);
        this.verifyPipelineIsRegisteredForProviderType(this.pipeline, this.providerType);
    }

    @Test
    public void testGetPipelineByName() {
        this.verifyPipelineIsNotRegistered(this.pipeline);
        this.pipelineRegistry.registerPipeline(this.pipeline);
        Pipeline result = this.pipelineRegistry.getPipelineByName(PIPELINE_ID);
        Assert.assertEquals((Object)this.pipeline, (Object)result);
    }

    @Test
    public void testGetPipelines() {
        List result = this.pipelineRegistry.getPipelines(0, 1000, "name", true);
        Assert.assertTrue((boolean)result.isEmpty());
        List<Pipeline> pipelines = InMemoryPipelineRegistryTest.mockPipelineList("", 10);
        pipelines.forEach(pipeline -> this.pipelineRegistry.registerPipeline(pipeline));
        result = this.pipelineRegistry.getPipelines(0, 1000, "name", true);
        for (Pipeline pipeline2 : pipelines) {
            Assert.assertTrue((boolean)result.contains(pipeline2));
        }
    }

    @Test
    public void testGetProviderType() {
        ProviderType result = this.pipelineRegistry.getProviderType(PIPELINE_ID);
        Assert.assertNull((Object)result);
        this.pipelineRegistry.registerPipeline(this.pipeline, this.providerType);
        result = this.pipelineRegistry.getProviderType(PIPELINE_ID);
        Assert.assertEquals((Object)this.providerType, (Object)result);
    }

    @Test
    public void getPipelinesForProvider() {
        ProviderType providerType1 = AlaSPITestCommons.mockProviderTypeSPI("providerType1");
        ProviderType providerType2 = AlaSPITestCommons.mockProviderTypeSPI("providerType2");
        List result = this.pipelineRegistry.getPipelines(0, 1000, "name", true);
        Assert.assertTrue((boolean)result.isEmpty());
        List<Pipeline> pipelines = InMemoryPipelineRegistryTest.mockPipelineList("providerType", 10);
        this.registerPipelinesForProviderType(pipelines, this.providerType);
        this.registerPipelinesForProviderType(InMemoryPipelineRegistryTest.mockPipelineList("providerType1", 10), providerType1);
        this.registerPipelinesForProviderType(InMemoryPipelineRegistryTest.mockPipelineList("providerType2", 10), providerType2);
        result = this.pipelineRegistry.getPipelines(0, 1000, "name", true);
        Assert.assertEquals((long)30L, (long)result.size());
        result = this.pipelineRegistry.getPipelines(this.providerType.getProviderTypeName(), this.providerType.getVersion(), 0, 1000, "name", true);
        Assert.assertEquals((long)pipelines.size(), (long)result.size());
        for (Pipeline pipeline : result) {
            Assert.assertTrue((boolean)result.contains(pipeline));
        }
    }

    private void verifyPipelineIsNotRegistered(Pipeline pipeline) {
        List pipelines = this.pipelineRegistry.getPipelines(0, 1000, "name", true);
        Assert.assertFalse((boolean)pipelines.contains(pipeline));
    }

    private void verifyPipelineIsRegistered(Pipeline pipeline) {
        List pipelines = this.pipelineRegistry.getPipelines(0, 1000, "name", true);
        Assert.assertTrue((boolean)pipelines.contains(pipeline));
    }

    private void verifyPipelineIsRegisteredForProviderType(Pipeline pipeline, ProviderType providerType) {
        List pipelines = this.pipelineRegistry.getPipelines(providerType.getProviderTypeName(), providerType.getVersion(), 0, 1000, "name", true);
        Assert.assertTrue((boolean)pipelines.contains(pipeline));
    }

    private static List<Pipeline> mockPipelineList(String suffix, int count) {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        for (int i = 0; i < count; ++i) {
            Pipeline pipeline = (Pipeline)Mockito.mock(Pipeline.class);
            Mockito.when((Object)pipeline.getName()).thenReturn((Object)("Pipeline.name." + suffix + Integer.toString(i)));
            pipelines.add(pipeline);
        }
        return pipelines;
    }

    private void registerPipelinesForProviderType(List<Pipeline> pipelines, ProviderType providerType) {
        pipelines.forEach(pipeline -> this.pipelineRegistry.registerPipeline(pipeline, providerType));
    }
}

