/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InMemoryRuntimeRegistryTest {
    protected static final int ELEMENTS_COUNT = 10;
    protected static final String PROVIDER_ID = "PROVIDER_ID";
    protected InMemoryRuntimeRegistry runtimeRegistry;
    protected ProviderType providerType;
    protected Provider provider;
    protected ProviderId providerId;
    protected Runtime runtime;

    @Before
    public void setUp() {
        this.providerType = AlaSPITestCommons.mockProviderTypeSPI("");
        this.provider = AlaSPITestCommons.mockProviderSPI(this.providerType, "");
        this.providerId = (ProviderId)Mockito.mock(ProviderId.class);
        Mockito.when((Object)this.providerId.getProviderType()).thenReturn((Object)this.providerType);
        Mockito.when((Object)this.providerId.getId()).thenReturn((Object)PROVIDER_ID);
        this.runtime = this.mockRuntime(this.providerId, "");
        this.runtimeRegistry = new InMemoryRuntimeRegistry();
    }

    @Test
    public void testRegisterProviderType() {
        this.runtimeRegistry.registerProviderType(this.providerType);
        this.verifyProviderTypeIsRegistered(this.providerType);
    }

    @Test
    public void testDeregisterProviderType() {
        this.runtimeRegistry.registerProviderType(this.providerType);
        this.verifyProviderTypeIsRegistered(this.providerType);
        this.runtimeRegistry.deregisterProviderType(this.providerType);
        this.verifyProviderTypeIsNotRegistered(this.providerType);
    }

    @Test
    public void testGetProviderTypes() {
        List result = this.runtimeRegistry.getProviderTypes(Integer.valueOf(0), Integer.valueOf(1000), "providerTypeName", true);
        Assert.assertTrue((boolean)result.isEmpty());
        List<ProviderType> providerTypes = AlaSPITestCommons.mockProviderTypeListSPI(10);
        providerTypes.forEach(providerType -> this.runtimeRegistry.registerProviderType(providerType));
        result = this.runtimeRegistry.getProviderTypes(Integer.valueOf(0), Integer.valueOf(1000), "providerTypeName", true);
        for (ProviderType providerType2 : providerTypes) {
            Assert.assertTrue((boolean)result.contains(providerType2));
        }
    }

    private void verifyProviderTypeIsRegistered(ProviderType providerType) {
        List result = this.runtimeRegistry.getProviderTypes(Integer.valueOf(0), Integer.valueOf(1000), "providerTypeName", true);
        Assert.assertTrue((boolean)result.contains(providerType));
    }

    private void verifyProviderTypeIsNotRegistered(ProviderType providerType) {
        List result = this.runtimeRegistry.getProviderTypes(Integer.valueOf(0), Integer.valueOf(1000), "providerTypeName", true);
        Assert.assertFalse((boolean)result.contains(providerType));
    }

    @Test
    public void testRegisterProvider() {
        this.runtimeRegistry.registerProvider(this.provider);
        this.verifyProviderIsRegistered(this.provider);
    }

    @Test
    public void testDeregisterProvider() {
        this.runtimeRegistry.registerProvider(this.provider);
        this.verifyProviderIsRegistered(this.provider);
        this.runtimeRegistry.deregisterProvider(this.provider);
        this.verifyProviderIsNotRegistered(this.provider);
    }

    @Test
    public void testDeregisterProviderById() {
        this.runtimeRegistry.registerProvider(this.provider);
        this.verifyProviderIsRegistered(this.provider);
        this.runtimeRegistry.deregisterProvider(this.provider.getId());
        this.verifyProviderIsNotRegistered(this.provider);
    }

    @Test
    public void testGetProviders() {
        List result = this.runtimeRegistry.getProviders(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        Assert.assertTrue((boolean)result.isEmpty());
        List<Provider> providers = AlaSPITestCommons.mockProviderListSPI(this.providerType, 10);
        providers.forEach(provider -> this.runtimeRegistry.registerProvider(provider));
        result = this.runtimeRegistry.getProviders(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        for (Provider provider2 : providers) {
            Assert.assertTrue((boolean)result.contains(provider2));
        }
    }

    @Test
    public void testGetProvider() {
        Provider result = this.runtimeRegistry.getProvider(this.provider.getId());
        Assert.assertNull((Object)result);
        this.runtimeRegistry.registerProvider(this.provider);
        result = this.runtimeRegistry.getProvider(this.provider.getId());
        Assert.assertEquals((Object)this.provider, (Object)result);
    }

    @Test
    public void testGetProvidersByType() {
        ProviderType providerType1 = AlaSPITestCommons.mockProviderTypeSPI("ProviderType1");
        ProviderType providerType2 = AlaSPITestCommons.mockProviderTypeSPI("ProviderType2");
        List<Provider> providers = AlaSPITestCommons.mockProviderListSPI(this.providerType, "1", 10);
        List<Provider> providersForType1 = AlaSPITestCommons.mockProviderListSPI(providerType1, "2", 10);
        List<Provider> providersForType2 = AlaSPITestCommons.mockProviderListSPI(providerType2, 10);
        ArrayList<Provider> allProviders = new ArrayList<Provider>();
        allProviders.addAll(providers);
        allProviders.addAll(providersForType1);
        allProviders.addAll(providersForType2);
        allProviders.forEach(provider -> this.runtimeRegistry.registerProvider(provider));
        List result = this.runtimeRegistry.getProvidersByType(this.providerType);
        Assert.assertEquals((long)providers.size(), (long)result.size());
        for (Provider provider2 : providers) {
            Assert.assertTrue((boolean)result.contains(provider2));
        }
    }

    protected void verifyProviderIsRegistered(Provider provider) {
        List result = this.runtimeRegistry.getProviders(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        Assert.assertTrue((boolean)result.contains(provider));
    }

    protected void verifyProviderIsNotRegistered(Provider provider) {
        List result = this.runtimeRegistry.getProviders(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        Assert.assertFalse((boolean)result.contains(provider));
    }

    @Test
    public void testRegisterRuntime() {
        this.runtimeRegistry.registerRuntime(this.runtime);
        this.verifyRuntimeIsRegistered(this.runtime);
    }

    @Test
    public void testGetRuntimes() {
        List result = this.runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        Assert.assertTrue((boolean)result.isEmpty());
        List<Runtime> runtimes = this.mockRuntimeList(this.providerId, "", 10);
        runtimes.forEach(runtime -> this.runtimeRegistry.registerRuntime(runtime));
        result = this.runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        for (Runtime runtime2 : runtimes) {
            Assert.assertTrue((boolean)result.contains(runtime2));
        }
    }

    @Test
    public void testGetRuntimeById() {
        String id = this.runtime.getId();
        this.runtimeRegistry.registerRuntime(this.runtime);
        Runtime result = this.runtimeRegistry.getRuntimeById(id);
        Assert.assertEquals((Object)this.runtime, (Object)result);
    }

    @Test
    public void testDeregisterRuntime() {
        String id = this.runtime.getId();
        RuntimeId runtimeId = (RuntimeId)Mockito.mock(RuntimeId.class);
        Mockito.when((Object)runtimeId.getId()).thenReturn((Object)id);
        this.runtimeRegistry.registerRuntime(this.runtime);
        this.verifyRuntimeIsRegistered(this.runtime);
        this.runtimeRegistry.deregisterRuntime(runtimeId);
        this.verifyRuntimeIsNotRegistered(this.runtime);
    }

    @Test
    public void getProvider() {
        MockProvider mockProvider = new MockProvider(PROVIDER_ID, this.providerType);
        ProviderId providerId = (ProviderId)Mockito.mock(ProviderId.class);
        Mockito.when((Object)providerId.getId()).thenReturn((Object)PROVIDER_ID);
        Mockito.when((Object)providerId.getProviderType()).thenReturn((Object)this.providerType);
        this.runtimeRegistry.registerProvider((Provider)mockProvider);
        Optional result = this.runtimeRegistry.getProvider(providerId, MockProvider.class);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)mockProvider, result.get());
    }

    protected void verifyRuntimeIsRegistered(Runtime runtime) {
        List result = this.runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        Assert.assertTrue((boolean)result.contains(runtime));
    }

    protected void verifyRuntimeIsNotRegistered(Runtime runtime) {
        List result = this.runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        Assert.assertFalse((boolean)result.contains(runtime));
    }

    protected Runtime mockRuntime(ProviderId providerId, String suffix) {
        Runtime runtime = (Runtime)Mockito.mock(Runtime.class);
        Mockito.when((Object)runtime.getId()).thenReturn((Object)("Runtime.id." + suffix));
        Mockito.when((Object)runtime.getName()).thenReturn((Object)("Runtime.name." + suffix));
        Mockito.when((Object)runtime.getProviderId()).thenReturn((Object)providerId);
        return runtime;
    }

    protected List<Runtime> mockRuntimeList(ProviderId providerId, String suffix, int count) {
        ArrayList<Runtime> runtimes = new ArrayList<Runtime>();
        for (int i = 0; i < count; ++i) {
            runtimes.add(this.mockRuntime(providerId, suffix + Integer.toString(i)));
        }
        return runtimes;
    }

    static class MockProvider
    implements Provider<MockProviderConfig> {
        private String id;
        private ProviderType providerType;

        public MockProvider(String id, ProviderType providerType) {
            this.id = id;
            this.providerType = providerType;
        }

        public String getId() {
            return this.id;
        }

        public ProviderType getProviderType() {
            return this.providerType;
        }

        public MockProviderConfig getConfig() {
            return (MockProviderConfig)Mockito.mock(MockProviderConfig.class);
        }
    }

    static class MockProviderConfig
    implements ProviderConfig {
        MockProviderConfig() {
        }
    }
}

