/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.registry.inmemory.InMemorySourceRegistry;
import org.guvnor.ala.source.Repository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.Path;

public class InMemorySourceRegistryTest {
    private static final String REPOSITORY_ID = "REPOSITORY_ID";
    private static final int REPOSITORIES_SIZE = 10;
    private InMemorySourceRegistry sourceRegistry;
    private Path path;
    private Repository repository;

    @Before
    public void setUp() {
        this.path = (Path)Mockito.mock(Path.class);
        this.repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.repository.getId()).thenReturn((Object)REPOSITORY_ID);
        this.sourceRegistry = new InMemorySourceRegistry();
    }

    @Test
    public void testRegisterRepositorySources() {
        this.sourceRegistry.registerRepositorySources(this.path, this.repository);
        List result = this.sourceRegistry.getAllRepositories();
        Assert.assertTrue((boolean)result.contains(this.repository));
    }

    @Test
    public void testGetAllRepositories() {
        int i;
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        ArrayList<Path> paths = new ArrayList<Path>();
        for (i = 0; i < 10; ++i) {
            paths.add((Path)Mockito.mock(Path.class));
            Repository repository = (Repository)Mockito.mock(Repository.class);
            Mockito.when((Object)repository.getId()).thenReturn((Object)(REPOSITORY_ID + Integer.toString(i)));
            repositories.add(repository);
        }
        for (i = 0; i < 10; ++i) {
            this.sourceRegistry.registerRepositorySources((Path)paths.get(i), (Repository)repositories.get(i));
        }
        List result = this.sourceRegistry.getAllRepositories();
        Assert.assertEquals((long)repositories.size(), (long)result.size());
        for (Repository repository : repositories) {
            Assert.assertTrue((boolean)result.contains(repository));
        }
    }
}

