/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.ui.model.AbstractHasKeyObject;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineError;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class PipelineExecutionTrace
extends AbstractHasKeyObject<PipelineExecutionTraceKey> {
    private Pipeline pipeline;
    private PipelineStatus pipelineStatus;
    private PipelineError pipelineError;
    private Map<String, PipelineStatus> stageStatusMap = new HashMap<String, PipelineStatus>();
    private Map<String, PipelineError> stageErrorMap = new HashMap<String, PipelineError>();

    public PipelineExecutionTrace(@MapsTo(value="key") PipelineExecutionTraceKey key, @MapsTo(value="pipeline") Pipeline pipeline, @MapsTo(value="pipelineStatus") PipelineStatus pipelineStatus, @MapsTo(value="pipelineError") PipelineError pipelineError, @MapsTo(value="stageStatusMap") Map<String, PipelineStatus> stageStatusMap, @MapsTo(value="stageErrorMap") Map<String, PipelineError> stageErrorMap) {
        super(key);
        this.pipeline = pipeline;
        this.pipelineStatus = pipelineStatus;
        this.pipelineError = pipelineError;
        this.stageStatusMap = stageStatusMap;
        this.stageErrorMap = stageErrorMap;
    }

    public PipelineExecutionTrace(PipelineExecutionTraceKey key) {
        super(key);
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public PipelineStatus getPipelineStatus() {
        return this.pipelineStatus;
    }

    public void setPipelineStatus(PipelineStatus pipelineStatus) {
        this.pipelineStatus = pipelineStatus;
    }

    public PipelineError getPipelineError() {
        return this.pipelineError;
    }

    public void setPipelineError(PipelineError pipelineError) {
        this.pipelineError = pipelineError;
    }

    public PipelineStatus getStageStatus(String stage) {
        return this.stageStatusMap.get(stage);
    }

    public void setStageStatus(String stage, PipelineStatus stageStatus) {
        this.stageStatusMap.put(stage, stageStatus);
    }

    public PipelineError getStageError(String stage) {
        return this.stageErrorMap.get(stage);
    }

    public void setStageError(String stage, PipelineError error) {
        this.stageErrorMap.put(stage, error);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineExecutionTrace)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineExecutionTrace trace = (PipelineExecutionTrace)o;
        if (this.pipeline != null ? !this.pipeline.equals(trace.pipeline) : trace.pipeline != null) {
            return false;
        }
        if (this.pipelineStatus != trace.pipelineStatus) {
            return false;
        }
        if (this.pipelineError != null ? !this.pipelineError.equals(trace.pipelineError) : trace.pipelineError != null) {
            return false;
        }
        if (this.stageStatusMap != null ? !this.stageStatusMap.equals(trace.stageStatusMap) : trace.stageStatusMap != null) {
            return false;
        }
        return this.stageErrorMap != null ? this.stageErrorMap.equals(trace.stageErrorMap) : trace.stageErrorMap == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.pipeline != null ? this.pipeline.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.pipelineStatus != null ? this.pipelineStatus.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.pipelineError != null ? this.pipelineError.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.stageStatusMap != null ? this.stageStatusMap.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.stageErrorMap != null ? this.stageErrorMap.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

