/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.handler;

import org.guvnor.ala.ui.handler.ProviderHandler;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class BaseProviderHandlerTest<T extends ProviderHandler> {
    protected T providerHandler;

    @Before
    public void setUp() {
        this.providerHandler = this.createProviderHandler();
    }

    @Test
    public void testGetPriority() {
        Assert.assertEquals((long)this.expectedPriority(), (long)this.providerHandler.getPriority());
    }

    @Test
    public void testAcceptProviderType() {
        Assert.assertTrue((boolean)this.providerHandler.acceptProviderType(this.expectedProviderType()));
    }

    @Test
    public void testAcceptArbitraryProviderType() {
        ProviderTypeKey providerTypeKey = (ProviderTypeKey)Mockito.mock(ProviderTypeKey.class);
        Assert.assertFalse((boolean)this.providerHandler.acceptProviderType(providerTypeKey));
    }

    protected abstract String getProviderTypeName();

    protected ProviderTypeKey expectedProviderType() {
        ProviderTypeKey providerTypeKey = (ProviderTypeKey)Mockito.mock(ProviderTypeKey.class);
        Mockito.when((Object)providerTypeKey.getId()).thenReturn((Object)this.getProviderTypeName());
        return providerTypeKey;
    }

    protected abstract T createProviderHandler();

    protected abstract int expectedPriority();
}

