/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.wildfly.client.provider;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.wildfly.client.provider.WF10ProviderConfigPresenter;
import org.guvnor.ala.ui.wildfly.service.TestConnectionResult;
import org.guvnor.ala.ui.wildfly.service.WildflyClientService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class WF10ProviderConfigPresenterTest {
    private static final String PROVIDER_NAME_VALUE = "PROVIDER_NAME_VALUE";
    private static final String HOST_VALUE = "HOST_VALUE";
    private static final String PORT_VALUE = "8080";
    private static final String MANAGEMENT_PORT_VALUE = "9990";
    private static final String USER_VALUE = "USER_VALUE";
    private static final String PASSWORD_VALUE = "PASSWORD_VALUE";
    private static final String EMPTY_VALUE = "";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    private static final String ERROR_MESSAGE_TRANSFORMED = "ERROR_MESSAGE_TRANSFORMED";
    private static final String SUCCESS_MESSAGE = "SUCCESS_MESSAGE";
    private static final String SUCCESS_MESSAGE_TRANSFORMED = "SUCCESS_MESSAGE_TRANSFORMED";
    @Mock
    private WF10ProviderConfigPresenter.View view;
    @Mock
    private WildflyClientService wildflyClientService;
    private Caller<WildflyClientService> wildflyClientServiceCaller;
    private WF10ProviderConfigPresenter presenter;
    @Mock
    private ContentChangeHandler changeHandler;

    @Before
    public void setUp() {
        this.wildflyClientServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.wildflyClientService));
        this.presenter = new WF10ProviderConfigPresenter(this.view, this.wildflyClientServiceCaller);
        this.presenter.init();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        this.presenter.addContentChangeHandler(this.changeHandler);
    }

    @Test
    public void testBuildProviderConfiguration() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)HOST_VALUE);
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)PORT_VALUE);
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)MANAGEMENT_PORT_VALUE);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        ProviderConfiguration configuration = this.presenter.buildProviderConfiguration();
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)this.presenter.getProviderName());
        Assert.assertEquals((Object)HOST_VALUE, configuration.getValues().get("host"));
        Assert.assertEquals((Object)PORT_VALUE, configuration.getValues().get("port"));
        Assert.assertEquals((Object)MANAGEMENT_PORT_VALUE, configuration.getValues().get("management-port"));
        Assert.assertEquals((Object)USER_VALUE, configuration.getValues().get("wildfly-user"));
        Assert.assertEquals((Object)PASSWORD_VALUE, configuration.getValues().get("wildfly-password"));
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testLoad() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("host", HOST_VALUE);
        values.put("port", PORT_VALUE);
        values.put("management-port", MANAGEMENT_PORT_VALUE);
        values.put("wildfly-user", USER_VALUE);
        values.put("wildfly-password", PASSWORD_VALUE);
        Provider provider = (Provider)Mockito.mock(Provider.class);
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        ProviderConfiguration configuration = (ProviderConfiguration)Mockito.mock(ProviderConfiguration.class);
        Mockito.when((Object)((ProviderKey)provider.getKey())).thenReturn((Object)providerKey);
        Mockito.when((Object)providerKey.getId()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Mockito.when((Object)provider.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.getValues()).thenReturn(values);
        this.presenter.load(provider);
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderName(PROVIDER_NAME_VALUE);
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setHost(HOST_VALUE);
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPort(PORT_VALUE);
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setManagementPort(MANAGEMENT_PORT_VALUE);
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsername(USER_VALUE);
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPassword("****");
    }

    @Test
    public void testGetProviderName() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)this.presenter.getProviderName());
    }

    @Test
    public void testGetHost() {
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)HOST_VALUE);
        Assert.assertEquals((Object)HOST_VALUE, (Object)this.presenter.getHost());
    }

    @Test
    public void testGetPort() {
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)PORT_VALUE);
        Assert.assertEquals((Object)PORT_VALUE, (Object)this.presenter.getPort());
    }

    @Test
    public void testGetManagementPort() {
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)MANAGEMENT_PORT_VALUE);
        Assert.assertEquals((Object)MANAGEMENT_PORT_VALUE, (Object)this.presenter.getManagementPort());
    }

    @Test
    public void testGetUser() {
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        Assert.assertEquals((Object)USER_VALUE, (Object)this.presenter.getUsername());
    }

    @Test
    public void testGetPassword() {
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        Assert.assertEquals((Object)PASSWORD_VALUE, (Object)this.presenter.getPassword());
    }

    @Test
    public void testIsValid() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)EMPTY_VALUE);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)HOST_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)PORT_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)MANAGEMENT_PORT_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        this.presenter.isValid(Assert::assertTrue);
    }

    @Test
    public void testDisable() {
        this.presenter.disable();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disable();
    }

    @Test
    public void testOnProviderNameChangeValid() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        this.presenter.onProviderNameChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderNameStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnProviderNameChangeInvalid() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onProviderNameChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderNameStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnHostChangeValid() {
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)HOST_VALUE);
        this.presenter.onHostChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setHostStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnHostChangeInvalid() {
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onHostChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setHostStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnPortChangeValid() {
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)PORT_VALUE);
        this.presenter.onPortChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPortStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnPortChangeInvalid() {
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onPortChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPortStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnManagementPortChangeValid() {
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)MANAGEMENT_PORT_VALUE);
        this.presenter.onManagementPortChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setManagementPortStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnManagementPortChangeInvalid() {
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onManagementPortChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setManagementPortStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnUserChangeValid() {
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        this.presenter.onUserNameChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsernameStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnUserChangeInvalid() {
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onUserNameChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsernameStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnPasswordChangeValid() {
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        this.presenter.onPasswordChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPasswordStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnPasswordChangeInvalid() {
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)EMPTY_VALUE);
        this.presenter.onPasswordChange();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPasswordStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnTestConnectionWithMissingParams() {
        Mockito.when((Object)this.view.getParamsNotCompletedErrorMessage()).thenReturn((Object)ERROR_MESSAGE);
        this.presenter.onTestConnection();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showInformationPopup(ERROR_MESSAGE);
    }

    @Test
    public void testOnTestConnectionWhenConnectionFailed() {
        Mockito.when((Object)this.view.getTestConnectionFailMessage(ERROR_MESSAGE)).thenReturn((Object)ERROR_MESSAGE_TRANSFORMED);
        TestConnectionResult result = (TestConnectionResult)Mockito.mock(TestConnectionResult.class);
        Mockito.when((Object)result.getManagementConnectionError()).thenReturn((Object)true);
        Mockito.when((Object)result.getManagementConnectionMessage()).thenReturn((Object)ERROR_MESSAGE);
        Mockito.when((Object)this.wildflyClientService.testConnection(HOST_VALUE, Integer.parseInt(PORT_VALUE), Integer.parseInt(MANAGEMENT_PORT_VALUE), USER_VALUE, PASSWORD_VALUE)).thenReturn((Object)result);
        this.fillConnectionParams();
        this.presenter.onTestConnection();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showInformationPopup(ERROR_MESSAGE_TRANSFORMED);
    }

    @Test
    public void testOnTestConnectionWhenConnectionSuccessful() {
        Mockito.when((Object)this.view.getTestConnectionSuccessfulMessage(SUCCESS_MESSAGE)).thenReturn((Object)SUCCESS_MESSAGE_TRANSFORMED);
        TestConnectionResult result = (TestConnectionResult)Mockito.mock(TestConnectionResult.class);
        Mockito.when((Object)result.getManagementConnectionError()).thenReturn((Object)false);
        Mockito.when((Object)result.getManagementConnectionMessage()).thenReturn((Object)SUCCESS_MESSAGE);
        Mockito.when((Object)this.wildflyClientService.testConnection(HOST_VALUE, Integer.parseInt(PORT_VALUE), Integer.parseInt(MANAGEMENT_PORT_VALUE), USER_VALUE, PASSWORD_VALUE)).thenReturn((Object)result);
        this.fillConnectionParams();
        this.presenter.onTestConnection();
        ((WF10ProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showInformationPopup(SUCCESS_MESSAGE_TRANSFORMED);
    }

    private void fillConnectionParams() {
        Mockito.when((Object)this.view.getHost()).thenReturn((Object)HOST_VALUE);
        Mockito.when((Object)this.view.getPort()).thenReturn((Object)PORT_VALUE);
        Mockito.when((Object)this.view.getManagementPort()).thenReturn((Object)MANAGEMENT_PORT_VALUE);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
    }
}

