/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.v1_1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.RowLocation;
import org.kie.dmn.model.v1_1.TArtifact;
import org.kie.dmn.model.v1_1.TDMNElement;
import org.kie.dmn.model.v1_1.TDRGElement;
import org.kie.dmn.model.v1_1.TDefinitions;
import org.kie.dmn.model.v1_1.TItemDefinition;
import org.kie.dmn.model.v1_1.TNamedElement;

public abstract class KieDMNModelInstrumentedBase
implements DMNModelInstrumentedBase {
    public static final String URI_FEEL = "http://www.omg.org/spec/FEEL/20140401";
    public static final String URI_DMN = "http://www.omg.org/spec/DMN/20151101/dmn.xsd";
    public static final String URI_KIE = "http://www.drools.org/kie/dmn/1.1";
    private Map<String, String> nsContext;
    private DMNModelInstrumentedBase parent;
    private final List<DMNModelInstrumentedBase> children = new ArrayList<DMNModelInstrumentedBase>();
    private Location location;
    private Map<QName, String> additionalAttributes = new HashMap<QName, String>();

    @Override
    public String getIdentifierString() {
        if (this instanceof TNamedElement && ((TNamedElement)this).getName() != null) {
            return ((TNamedElement)this).getName();
        }
        if (this instanceof TDMNElement && ((TDMNElement)this).getId() != null) {
            return ((TDMNElement)this).getId();
        }
        return "[unnamed " + this.getClass().getSimpleName() + "]";
    }

    @Override
    public DMNModelInstrumentedBase getParentDRDElement() {
        if (this instanceof TDRGElement || this instanceof TArtifact || this instanceof TItemDefinition && this.parent != null && this.parent instanceof TDefinitions) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getParentDRDElement();
        }
        return null;
    }

    @Override
    public Map<String, String> getNsContext() {
        if (this.nsContext == null) {
            this.nsContext = new HashMap<String, String>();
        }
        return this.nsContext;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.nsContext != null && this.nsContext.containsKey(prefix)) {
            return this.nsContext.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public Optional<String> getPrefixForNamespaceURI(String namespaceURI) {
        if (this.nsContext != null && this.nsContext.containsValue(namespaceURI)) {
            return this.nsContext.entrySet().stream().filter(kv -> ((String)kv.getValue()).equals(namespaceURI)).findFirst().map(Map.Entry::getKey);
        }
        if (this.parent != null) {
            return this.parent.getPrefixForNamespaceURI(namespaceURI);
        }
        return Optional.empty();
    }

    @Override
    public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public Map<QName, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public DMNModelInstrumentedBase getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DMNModelInstrumentedBase parent) {
        this.parent = parent;
    }

    @Override
    public List<DMNModelInstrumentedBase> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void addChildren(DMNModelInstrumentedBase child) {
        this.children.add(child);
    }

    @Override
    public void setLocation(Location location) {
        this.location = new RowLocation(location);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getURIFEEL() {
        return URI_FEEL;
    }
}

