/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.service;

import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.shared.discussion.CommentAddedEvent;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public abstract class KieService<T> {
    protected static Logger logger = LoggerFactory.getLogger(KieService.class);
    @Inject
    protected SourceServices sourceServices;
    @Inject
    protected Event<CommentAddedEvent> commentAddedEvent;
    @Inject
    protected PathResolver pathResolver;
    @Inject
    protected MetadataServerSideService metadataService;
    @Inject
    protected KieModuleService moduleService;
    @Inject
    protected WorkspaceProjectService projectService;
    @Inject
    protected KieServiceOverviewLoader overviewLoader;
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;

    public T loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            Path ioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            if (this.pathResolver.isDotFile(ioPath)) {
                Path ioPrincipleFilePath = this.pathResolver.resolveMainFilePath(ioPath);
                if (!this.ioService.exists(ioPrincipleFilePath)) {
                    ioPrincipleFilePath = ioPath;
                }
                org.uberfire.backend.vfs.Path principleFilePath = Paths.convert((Path)ioPrincipleFilePath);
                return this.constructContent(principleFilePath, this.overviewLoader.loadOverview(principleFilePath));
            }
            return this.constructContent(path, this.overviewLoader.loadOverview(path));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected abstract T constructContent(org.uberfire.backend.vfs.Path var1, Overview var2);

    public String getSource(org.uberfire.backend.vfs.Path path) throws SourceGenerationFailedException {
        Path convertedPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.sourceServices.hasServiceFor(convertedPath)) {
            return this.sourceServices.getServiceFor(convertedPath).getSource(convertedPath);
        }
        return "";
    }

    protected void fireMetadataSocialEvents(org.uberfire.backend.vfs.Path path, Metadata currentMetadata, Metadata newMetadata) {
        List currentDiscussion;
        List newDiscussion = newMetadata != null ? newMetadata.getDiscussion() : null;
        List list = currentDiscussion = currentMetadata != null ? currentMetadata.getDiscussion() : null;
        if (newDiscussion != null && newDiscussion.size() > 0) {
            for (DiscussionRecord newRecord : newDiscussion) {
                if (newRecord == null || currentDiscussion != null && currentDiscussion.contains(newRecord)) continue;
                this.commentAddedEvent.fire((Object)new CommentAddedEvent(newRecord.getAuthor(), path, newRecord.getNote(), newRecord.getTimestamp()));
            }
        }
    }
}

