/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.expression;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.model.Index;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expression.AbstractExpressionBuilder;

public class FlowExpressionBuilder
extends AbstractExpressionBuilder {
    public static final String EXPR_CALL = "D.expr";
    public static final String REACT_ON_CALL = "reactOn";
    public static final String BIND_CALL = "D.bind";

    public FlowExpressionBuilder(RuleContext context) {
        super(context);
    }

    @Override
    public Expression buildExpressionWithIndexing(DrlxParseSuccess drlxParseResult) {
        String exprId = drlxParseResult.getExprId();
        MethodCallExpr exprDSL = new MethodCallExpr(null, EXPR_CALL);
        if (exprId != null && !"".equals(exprId)) {
            exprDSL.addArgument((Expression)new StringLiteralExpr(exprId));
        }
        exprDSL = this.buildExpression(drlxParseResult, exprDSL);
        exprDSL = this.buildIndexedBy(drlxParseResult, exprDSL);
        exprDSL = this.buildReactOn(drlxParseResult, exprDSL);
        return exprDSL;
    }

    private MethodCallExpr buildExpression(DrlxParseSuccess drlxParseResult, MethodCallExpr exprDSL) {
        ArrayList<String> usedDeclarationsWithUnification = new ArrayList<String>();
        if (drlxParseResult.isPatternBindingUnification()) {
            usedDeclarationsWithUnification.add(drlxParseResult.getPatternBinding());
        } else if (drlxParseResult.getPatternBinding() != null) {
            exprDSL.addArgument(this.context.getVarExpr(drlxParseResult.getPatternBinding()));
        }
        usedDeclarationsWithUnification.addAll(drlxParseResult.getUsedDeclarations());
        usedDeclarationsWithUnification.stream().filter(s -> !drlxParseResult.isSkipThisAsParam() || !s.equals(drlxParseResult.getPatternBinding())).map(this.context::getVarExpr).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        if (drlxParseResult.getRightLiteral() != null) {
            exprDSL.addArgument("" + drlxParseResult.getRightLiteral());
        }
        exprDSL.addArgument(this.buildConstraintExpression(drlxParseResult, drlxParseResult.getExpr()));
        return exprDSL;
    }

    @Override
    public MethodCallExpr buildBinding(DrlxParseSuccess drlxParseResult) {
        MethodCallExpr bindDSL = new MethodCallExpr(null, BIND_CALL);
        if (drlxParseResult.hasUnificationVariable()) {
            bindDSL.addArgument(this.context.getVarExpr(drlxParseResult.getUnificationVariable()));
        } else {
            bindDSL.addArgument(this.context.getVarExpr(drlxParseResult.getExprBinding()));
        }
        Expression constraintExpression = this.getConstraintExpression(drlxParseResult);
        MethodCallExpr bindAsDSL = new MethodCallExpr((Expression)bindDSL, "as");
        bindAsDSL.addArgument(this.context.getVarExpr(drlxParseResult.getPatternBinding()));
        drlxParseResult.getUsedDeclarationsOnLeft().forEach(d -> {
            MethodCallExpr cfr_ignored_0 = (MethodCallExpr)bindAsDSL.addArgument(this.context.getVar((String)d));
        });
        bindAsDSL.addArgument(constraintExpression);
        return this.buildReactOn(drlxParseResult, bindAsDSL);
    }

    private MethodCallExpr buildReactOn(DrlxParseSuccess drlxParseResult, MethodCallExpr exprDSL) {
        if (!drlxParseResult.getReactOnProperties().isEmpty() && this.context.isPropertyReactive(drlxParseResult.getPatternType())) {
            exprDSL = new MethodCallExpr((Expression)exprDSL, REACT_ON_CALL);
            drlxParseResult.getReactOnProperties().stream().map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        }
        if (!drlxParseResult.getWatchedProperties().isEmpty()) {
            exprDSL = new MethodCallExpr((Expression)exprDSL, "watch");
            drlxParseResult.getWatchedProperties().stream().map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        }
        return exprDSL;
    }

    private MethodCallExpr buildIndexedBy(DrlxParseSuccess drlxParseResult, MethodCallExpr exprDSL) {
        if (drlxParseResult.isUnification()) {
            TypedExpression left = drlxParseResult.getLeft();
            TypedExpression right = drlxParseResult.getRight();
            LambdaExpr indexedBy_leftOperandExtractor = new LambdaExpr();
            indexedBy_leftOperandExtractor.addParameter(new Parameter((org.drools.javaparser.ast.type.Type)new UnknownType(), "_this"));
            boolean leftContainsThis = left.getExpression().toString().contains("_this");
            indexedBy_leftOperandExtractor.setBody((Statement)new ExpressionStmt(leftContainsThis ? left.getExpression() : right.getExpression()));
            MethodCallExpr indexedByDSL = new MethodCallExpr((Expression)exprDSL, "indexedBy");
            indexedByDSL.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)this.getIndexType(left, right).getCanonicalName())));
            indexedByDSL.addArgument(Index.ConstraintType.class.getCanonicalName() + ".EQUAL");
            indexedByDSL.addArgument("-1");
            indexedByDSL.addArgument((Expression)indexedBy_leftOperandExtractor);
            indexedByDSL.addArgument("" + null);
            return indexedByDSL;
        }
        if (!this.hasIndex(drlxParseResult)) {
            return exprDSL;
        }
        TypedExpression left = drlxParseResult.getLeft();
        TypedExpression right = drlxParseResult.getRight();
        if (!drlxParseResult.isBetaNode() && !(right.getExpression() instanceof LiteralExpr)) {
            return exprDSL;
        }
        FieldAccessExpr indexedBy_constraintType = new FieldAccessExpr((Expression)new NameExpr("org.drools.model.Index.ConstraintType"), drlxParseResult.getDecodeConstraintType().toString());
        LambdaExpr indexedBy_leftOperandExtractor = new LambdaExpr();
        indexedBy_leftOperandExtractor.addParameter(new Parameter((org.drools.javaparser.ast.type.Type)new UnknownType(), "_this"));
        boolean leftContainsThis = left.getExpression().toString().contains("_this");
        indexedBy_leftOperandExtractor.setBody((Statement)new ExpressionStmt(leftContainsThis ? left.getExpression() : right.getExpression()));
        MethodCallExpr indexedByDSL = new MethodCallExpr((Expression)exprDSL, "indexedBy");
        indexedByDSL.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)this.getIndexType(left, right).getCanonicalName())));
        indexedByDSL.addArgument((Expression)indexedBy_constraintType);
        indexedByDSL.addArgument("" + indexIdGenerator.getFieldId(drlxParseResult.getPatternType(), left.getFieldName()));
        indexedByDSL.addArgument((Expression)indexedBy_leftOperandExtractor);
        Collection<String> usedDeclarations = drlxParseResult.getUsedDeclarations();
        Type leftType = left.getType();
        if (this.isAlphaIndex(usedDeclarations)) {
            indexedByDSL.addArgument(this.narrowExpressionToType(right, leftType));
        } else {
            this.addIndexedByDeclaration(left, right, leftContainsThis, indexedByDSL, usedDeclarations, leftType);
        }
        return indexedByDSL;
    }
}

