/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class DataEnumLoader {
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, String[]> data;

    public DataEnumLoader(String mvelSource, MVELEvaluator mvelEvaluator) {
        this(mvelSource, Thread.currentThread().getContextClassLoader(), mvelEvaluator);
    }

    public DataEnumLoader(String mvelSource, ClassLoader classLoader, MVELEvaluator mvelEvaluator) {
        this.data = this.loadEnum(mvelSource, classLoader, mvelEvaluator);
    }

    private Map<String, String[]> loadEnum(String mvelSource, ClassLoader classLoader, MVELEvaluator mvelEvaluator) {
        Object mvelData;
        if (mvelSource == null || mvelSource.trim().equals("")) {
            return Collections.emptyMap();
        }
        mvelSource = mvelSource.startsWith("=") ? mvelSource.substring(1) : "[ " + this.addCommasForNewLines(mvelSource) + " ]";
        try {
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pconf.setClassLoader(classLoader);
            Serializable compiled = MVEL.compileExpression((String)mvelSource, (ParserContext)pctx);
            mvelData = mvelEvaluator.executeExpression((Object)compiled, new HashMap());
        }
        catch (RuntimeException e) {
            this.addError("Unable to load enumeration data.");
            this.addError(e.getMessage());
            this.addError("Error type: " + e.getClass().getName());
            return Collections.emptyMap();
        }
        if (!(mvelData instanceof Map)) {
            this.addError("The expression is not a map, it is a " + mvelData.getClass().getName());
            return Collections.emptyMap();
        }
        Map map = (Map)mvelData;
        HashMap<String, String[]> newMap = new HashMap<String, String[]>();
        for (Map.Entry entry : map.entrySet()) {
            String key = this.makeEnumKey((String)entry.getKey());
            this.validateKey(key);
            Object list = entry.getValue();
            if (!(list instanceof List) && !(list instanceof String)) {
                if (list == null) {
                    this.addError("The item with " + key + " is null.");
                } else {
                    this.addError("The item with " + key + " is not a list or a string, it is a " + list.getClass().getName());
                }
                return Collections.emptyMap();
            }
            if (list instanceof String) {
                newMap.put(key, new String[]{(String)list});
                continue;
            }
            List items = (List)list;
            String[] newItems = new String[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                Object listItem = items.get(i);
                newItems[i] = !(listItem instanceof String) ? listItem.toString() : (String)listItem;
            }
            newMap.put(key, newItems);
        }
        return newMap;
    }

    private void validateKey(String key) {
        Pattern pattern = Pattern.compile(".*(\\[.*\\])");
        Matcher matcher = pattern.matcher(key);
        if (!matcher.matches()) {
            return;
        }
        if (matcher.groupCount() > 2) {
            this.errors.add("Invalid dependent definition: Only [..] accepted.");
            return;
        }
        String dependencySegment = matcher.group(1);
        if (dependencySegment.equals("[]")) {
            this.errors.add("Invalid dependent definition: Empty [] detected.");
            return;
        }
        if (dependencySegment.contains("\"")) {
            this.errors.add("Invalid dependent definition: Found quote literal.");
            return;
        }
        if (dependencySegment.contains("=")) {
            this.validateSimpleEnumKey(dependencySegment);
        } else {
            this.validateAdvancedEnumKey(dependencySegment);
        }
    }

    private void validateSimpleEnumKey(String dependencySegment) {
        if (dependencySegment.matches("\\[\\s*=\\s*\\]")) {
            this.errors.add("Invalid dependent definition: No field or value detected.");
            return;
        }
        if (dependencySegment.matches("\\[\\s*=\\S+\\]")) {
            this.errors.add("Invalid dependent definition: No field detected.");
            return;
        }
        if (dependencySegment.matches("\\[\\S+=\\s*\\]")) {
            this.errors.add("Invalid dependent definition: No value detected.");
            return;
        }
    }

    private void validateAdvancedEnumKey(String dependencySegment) {
        if (dependencySegment.matches("\\[\\s*,\\s*\\]")) {
            this.errors.add("Invalid definition: Field definitions are incomplete.");
            return;
        }
        if (dependencySegment.matches("\\[\\s*,\\S+\\]")) {
            this.errors.add("Invalid definition: Field definitions are incomplete.");
            return;
        }
        if (dependencySegment.matches("\\[\\S+,\\s*\\]")) {
            this.errors.add("Invalid definition: Field definitions are incomplete.");
            return;
        }
    }

    private String addCommasForNewLines(String mvelSource) {
        StringTokenizer st = new StringTokenizer(mvelSource, "\r\n");
        StringBuilder buf = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (st.hasMoreTokens() && line.endsWith(",")) {
                buf.append(line);
            } else {
                buf.append(line);
                if (st.hasMoreTokens()) {
                    buf.append(",");
                }
            }
            if (!st.hasMoreTokens()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    private void addError(String string) {
        this.errors.add(string);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Map<String, String[]> getData() {
        return this.data;
    }

    private String makeEnumKey(String userDefinedKey) {
        String systemDefinedKey = userDefinedKey.replace(".", "#");
        return systemDefinedKey;
    }
}

