/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lesscss.FileResource;
import org.lesscss.HttpResource;
import org.lesscss.Resource;
import org.lesscss.deps.org.apache.commons.io.IOUtils;
import org.lesscss.deps.org.apache.commons.io.input.BOMInputStream;
import org.lesscss.logging.LessLogger;
import org.lesscss.logging.LessLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessSource {
    private static LessLogger logger = LessLoggerFactory.getLogger(LessSource.class);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^(?!\\s*//\\s*).*(@import\\s+(url\\(|\\((less|css)\\))?\\s*(\"|')(.+)\\s*(\"|')(\\))?(.*);).*$", 8);
    private Resource resource;
    private String content;
    private String normalizedContent;
    private Map<String, LessSource> imports = new LinkedHashMap<String, LessSource>();

    public LessSource(Resource resource) throws IOException {
        this(resource, Charset.defaultCharset());
    }

    public LessSource(Resource resource, Charset charset) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        if (!resource.exists()) {
            throw new IOException("Resource " + resource + " not found.");
        }
        this.resource = resource;
        this.content = this.normalizedContent = this.loadResource(resource, charset);
        this.resolveImports();
    }

    public LessSource(File input) throws IOException {
        this(new FileResource(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadResource(Resource resource, Charset charset) throws IOException {
        BOMInputStream inputStream = new BOMInputStream(resource.getInputStream());
        try {
            if (inputStream.hasBOM()) {
                logger.debug("BOM found %s", inputStream.getBOMCharsetName());
                String string = IOUtils.toString((InputStream)inputStream, inputStream.getBOMCharsetName());
                return string;
            }
            logger.debug("Using charset " + charset.name());
            String string = IOUtils.toString((InputStream)inputStream, charset.name());
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public String getAbsolutePath() {
        return this.resource.toString();
    }

    public String getContent() {
        return this.content;
    }

    public String getNormalizedContent() {
        return this.normalizedContent;
    }

    public long getLastModified() {
        return this.resource.lastModified();
    }

    public long getLastModifiedIncludingImports() {
        long lastModified = this.getLastModified();
        for (Map.Entry<String, LessSource> entry : this.imports.entrySet()) {
            LessSource importedLessSource = entry.getValue();
            long importedLessSourceLastModified = importedLessSource.getLastModifiedIncludingImports();
            if (importedLessSourceLastModified <= lastModified) continue;
            lastModified = importedLessSourceLastModified;
        }
        return lastModified;
    }

    public Map<String, LessSource> getImports() {
        return this.imports;
    }

    private void resolveImports() throws IOException {
        Matcher importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
        while (importMatcher.find()) {
            String importedResource = importMatcher.group(5);
            importedResource = importedResource.matches(".*\\.(le?|c)ss$") ? importedResource : importedResource + ".less";
            String importType = importMatcher.group(3) == null ? importedResource.substring(importedResource.lastIndexOf(".") + 1) : importMatcher.group(3);
            if (!importType.equals("less")) continue;
            logger.debug("Importing %s", importedResource);
            if (!this.imports.containsKey(importedResource)) {
                LessSource importedLessSource = new LessSource(this.getImportedResource(importedResource));
                this.imports.put(importedResource, importedLessSource);
                this.normalizedContent = this.includeImportedContent(importedLessSource, importMatcher);
                importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
                continue;
            }
            this.normalizedContent = this.normalizedContent.substring(0, importMatcher.start(1)) + this.normalizedContent.substring(importMatcher.end(1));
            importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
        }
    }

    private Resource getImportedResource(String importedResource) throws IOException {
        try {
            if (importedResource.startsWith("http:") || importedResource.startsWith("https:")) {
                return new HttpResource(importedResource);
            }
            return this.resource.createRelative(importedResource);
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException(importedResource).initCause(e);
        }
    }

    private String includeImportedContent(LessSource importedLessSource, Matcher importMatcher) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.normalizedContent.substring(0, importMatcher.start(1)));
        String mediaQuery = importMatcher.group(8);
        if (mediaQuery != null && mediaQuery.length() > 0) {
            builder.append("@media");
            builder.append(mediaQuery);
            builder.append("{\n");
        }
        builder.append(importedLessSource.getNormalizedContent());
        if (mediaQuery != null && mediaQuery.length() > 0) {
            builder.append("}\n");
        }
        builder.append(this.normalizedContent.substring(importMatcher.end(1)));
        return builder.toString();
    }

    public String getName() {
        return this.resource.getName();
    }
}

