/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl;

import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.data.modeller.model.Source;
import org.kie.workbench.common.forms.migration.legacy.model.DataHolder;
import org.kie.workbench.common.forms.migration.legacy.model.Field;
import org.kie.workbench.common.forms.migration.legacy.model.Form;
import org.kie.workbench.common.forms.migration.tool.FormMigrationSummary;
import org.kie.workbench.common.forms.migration.tool.Resource;
import org.kie.workbench.common.forms.migration.tool.Result;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationContext;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.FieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.FormAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.UnSupportedFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.LayoutHelper;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.decorators.DecoratorFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.CharacterFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.CheckBoxFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.DatesFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.DecimalTextFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.DocumentFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.InputTextFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.IntegerTextFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.MultipleSubformFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.MultiplesValuesAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.RadioGroupFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.SelectBoxFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.SubformFieldAdapter;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.TextAreaFieldAdapter;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractFormAdapter
implements FormAdapter {
    protected Map<String, FieldAdapter> adaptersRegistry = new HashMap<String, FieldAdapter>();
    protected Map<String, UnSupportedFieldAdapter> unSupportedAdapters = new HashMap<String, UnSupportedFieldAdapter>();
    protected MigrationContext migrationContext;

    public AbstractFormAdapter(MigrationContext migrationContext) {
        this.migrationContext = migrationContext;
        this.registerAdapter(new InputTextFieldAdapter());
        this.registerAdapter(new CharacterFieldAdapter());
        this.registerAdapter(new TextAreaFieldAdapter());
        this.registerAdapter(new IntegerTextFieldAdapter());
        this.registerAdapter(new DecimalTextFieldAdapter());
        this.registerAdapter(new CheckBoxFieldAdapter());
        this.registerAdapter(new DatesFieldAdapter());
        this.registerAdapter(new SelectBoxFieldAdapter());
        this.registerAdapter(new RadioGroupFieldAdapter());
        this.registerAdapter(new SubformFieldAdapter());
        this.registerAdapter(new MultipleSubformFieldAdapter());
        this.registerAdapter(new DecoratorFieldAdapter());
        this.registerAdapter(new MultiplesValuesAdapter());
        this.registerAdapter(new DocumentFieldAdapter());
    }

    protected void registerAdapter(FieldAdapter adapter) {
        Stream.of(adapter.getLegacyFieldTypeCodes()).forEach(code -> this.adaptersRegistry.put((String)code, adapter));
        if (adapter instanceof UnSupportedFieldAdapter) {
            UnSupportedFieldAdapter unSupportedFieldAdapter = (UnSupportedFieldAdapter)adapter;
            Stream.of(unSupportedFieldAdapter.getLegacySupportedFieldTypeCodes()).forEach(code -> this.unSupportedAdapters.put((String)code, unSupportedFieldAdapter));
        }
    }

    @Override
    public List<FormMigrationSummary> migrateSummaries() {
        List<FormMigrationSummary> filteredSummaries = this.migrationContext.getSummaries().stream().filter(this.getFilter()).collect(Collectors.toList());
        if (filteredSummaries != null) {
            filteredSummaries.forEach(this::migrate);
        }
        return filteredSummaries;
    }

    protected abstract Predicate<FormMigrationSummary> getFilter();

    protected void migrate(FormMigrationSummary formSummary) {
        this.info("Starting migration for Form [" + formSummary.getOriginalForm().getPath().getFileName() + "]");
        FormModel formModel = this.extractFormModel(formSummary);
        if (formModel == null) {
            this.fail(formSummary, "Impossible to identify a valid Model for new form. This might mean that the form has a reference to a missing Data Object or an unexisting BPM Process / Task");
            return;
        }
        this.doCreateFormDefinition(formModel, formSummary);
        this.info("Form succesfully migrated");
    }

    protected void doCreateFormDefinition(FormModel formModel, FormMigrationSummary formSummary) {
        Form originalForm = formSummary.getOriginalForm().get();
        FormDefinition newFormDefinition = new FormDefinition(formModel);
        newFormDefinition.setId(String.valueOf(originalForm.getId()));
        newFormDefinition.setName(formSummary.getBaseFormName());
        Path originalPath = Paths.convert((org.uberfire.backend.vfs.Path)formSummary.getOriginalForm().getPath());
        Path newPath = originalPath.getParent().resolve(formSummary.getBaseFormName() + "." + "frm");
        formSummary.setNewFormResource(new Resource<FormDefinition>(newFormDefinition, Paths.convert((Path)newPath)));
        this.migrateFields(originalForm.getFormFields(), newFormDefinition, formSummary);
    }

    protected void migrateFields(Set<Field> fields, FormDefinition newForm, FormMigrationSummary formSummary) {
        LayoutHelper helper = new LayoutHelper();
        fields.forEach(originalField -> {
            String originalTypeCode;
            FieldAdapter adapter;
            if (!StringUtils.isEmpty((CharSequence)originalField.getMovedToForm())) {
                return;
            }
            if (!Boolean.TRUE.equals(originalField.getGroupWithPrevious())) {
                helper.newRow();
            }
            if ((adapter = this.adaptersRegistry.get(originalTypeCode = originalField.getFieldType().getCode())) == null) {
                UnSupportedFieldAdapter unSupportedFieldAdapter = this.unSupportedAdapters.get(originalTypeCode);
                if (unSupportedFieldAdapter != null) {
                    this.warn("Problems migrating field '" + originalField.getFieldName() + "': the original field has an unsupported field type '" + originalTypeCode + "'. It will be added on the new Form as a '" + unSupportedFieldAdapter.getNewFieldType() + "'");
                    unSupportedFieldAdapter.parseField((Field)originalField, formSummary, newForm, helper::add);
                } else {
                    this.warn("Cannot migrate field '" + originalField.getFieldName() + "': Unsupported field type '" + originalTypeCode + "'");
                    Formatter formatter = new Formatter();
                    formatter.format("<div class='alert'><span class='pficon pficon-warning-triangle-o'></span>Impossible to migrate field <strong>%s</strong> from the old jBPM Form: It has an unsupported type <strong>%s</strong>. Please try to add it back again to the form using the right Form Control</div>", originalField.getFieldName(), originalTypeCode);
                    LayoutComponent component = new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTMLLayoutDragComponent");
                    component.addProperty("HTML_CODE", formatter.toString());
                    formatter.close();
                    helper.add(component);
                }
            } else {
                try {
                    adapter.parseField((Field)originalField, formSummary, newForm, helper::add);
                }
                catch (Exception ex) {
                    this.warn("Cannot migrate field '" + originalField.getFieldName() + "': Unexpected error, see message for details");
                    ex.printStackTrace(this.migrationContext.getSystem().err());
                }
            }
        });
        newForm.setLayoutTemplate(helper.build());
    }

    protected abstract FormModel extractFormModel(FormMigrationSummary var1);

    protected FormModel createModelForDO(DataHolder dataHolder) {
        String className = dataHolder.getClassName();
        String modelName = className.substring(className.lastIndexOf(".") + 1);
        DataObjectFormModel formModel = new DataObjectFormModel(modelName, className);
        if (Boolean.TRUE.equals(Boolean.parseBoolean(dataHolder.getSupportedType()))) {
            formModel.setSource(Source.EXTERNAL);
        }
        return formModel;
    }

    protected void info(String message) {
        this.migrationContext.getSystem().out().println("[INFO] " + message);
    }

    protected void fail(FormMigrationSummary summary, String message) {
        summary.setResult(Result.FAILURE);
        this.migrationContext.getSystem().err().println("[ERROR] Form [" + summary.getOriginalForm().getPath().getFileName() + "] cannot be migrated: " + message);
    }

    protected void warn(String message) {
        this.migrationContext.getSystem().out().println("[WARNING] " + message);
    }
}

