/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields;

import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.HasPlaceHolder;
import org.kie.workbench.common.forms.migration.legacy.model.Field;
import org.kie.workbench.common.forms.migration.tool.FormMigrationSummary;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.FieldAdapter;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.impl.ModelPropertyImpl;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;

public abstract class AbstractFieldAdapter
implements FieldAdapter {
    public static final String DRAGGABLE_TYPE = "org.kie.workbench.common.forms.editor.client.editor.rendering.EditorFieldLayoutComponent";

    @Override
    public void parseField(Field originalField, FormMigrationSummary formSummary, FormDefinition newFormDefinition, Consumer<LayoutComponent> layoutElementConsumer) {
        FieldDefinition fieldDefinition = this.getFieldDefinition(originalField);
        fieldDefinition.setId(String.valueOf(originalField.getId()));
        fieldDefinition.setName(originalField.getFieldName());
        fieldDefinition.setLabel(this.lookupI18nValue(originalField.getLabel()));
        fieldDefinition.setHelpMessage(this.lookupI18nValue(originalField.getTitle()));
        fieldDefinition.setStandaloneClassName((String)StringUtils.defaultIfBlank((CharSequence)originalField.getBag(), (CharSequence)originalField.getFieldType().getFieldClass()));
        fieldDefinition.setReadOnly(originalField.getReadonly());
        fieldDefinition.setRequired(originalField.getFieldRequired());
        String binding = StringUtils.defaultString((String)((String)StringUtils.defaultIfBlank((CharSequence)originalField.getInputBinding(), (CharSequence)originalField.getOutputBinding())));
        if (!StringUtils.isEmpty((CharSequence)binding)) {
            if (binding.contains("/")) {
                binding = binding.substring(binding.indexOf("/") + 1);
            }
            ModelPropertyImpl property = new ModelPropertyImpl(binding, fieldDefinition.getFieldTypeInfo());
            newFormDefinition.getModel().getProperties().add(property);
        }
        fieldDefinition.setBinding(binding);
        if (fieldDefinition instanceof HasPlaceHolder) {
            ((HasPlaceHolder)fieldDefinition).setPlaceHolder(fieldDefinition.getLabel());
        }
        newFormDefinition.getFields().add(fieldDefinition);
        LayoutComponent component = new LayoutComponent(DRAGGABLE_TYPE);
        component.addProperty("form_id", newFormDefinition.getId());
        component.addProperty("field_id", fieldDefinition.getId());
        layoutElementConsumer.accept(component);
    }

    protected abstract FieldDefinition getFieldDefinition(Field var1);
}

