/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.nodeTypes.NodeWithName;
import org.drools.javaparser.printer.PrintUtil;

public class Generator {
    public static void main(String[] args) {
        System.out.println("Generator...");
        Stream.of(args).forEach(System.out::println);
        try {
            Files.list(Paths.get(args[0], new String[0])).filter(path -> path.toFile().isFile() && path.toString().endsWith(".drlx")).forEach(x -> Generator.processDRLFilePath(x, Paths.get(args[1], new String[0]), Paths.get(args[2], new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void processDRLFilePath(Path fromFile, Path toDirectoryJava, Path toDirectoryDrl) {
        CompilationUnit compilationUnit;
        try {
            compilationUnit = JavaParser.parse(new FileReader(fromFile.toFile()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        ClassOrInterfaceDeclaration unitClass = (ClassOrInterfaceDeclaration)compilationUnit.getType(0);
        String pkg = compilationUnit.getPackageDeclaration().map(NodeWithName::getNameAsString).orElse("defaultpkg");
        String unit = unitClass.getNameAsString();
        String unitPath = pkg.replace(".", "/") + "/" + unit;
        Path javaDestinationPath = Paths.get(toDirectoryJava.toString(), pkg.replace(".", "/"));
        System.out.println("javaDestinationPath: " + javaDestinationPath);
        javaDestinationPath.toFile().mkdirs();
        Path drlDestinationPath = Paths.get(toDirectoryDrl.toString(), pkg.replace(".", "/"));
        System.out.println("drlDestinationPath: " + drlDestinationPath);
        drlDestinationPath.toFile().mkdirs();
        Path javaFilePath = Paths.get(toDirectoryJava.toString(), unitPath + ".java");
        Path drlFilePath = Paths.get(toDirectoryDrl.toString(), unitPath + ".drl");
        System.out.println("Writing java file: " + javaFilePath);
        Generator.writeFile(javaFilePath, PrintUtil.toJava(compilationUnit));
        System.out.println("Writing drl file: " + drlFilePath);
        Generator.writeFile(drlFilePath, PrintUtil.toDrl(compilationUnit));
    }

    private static void writeFile(Path path, String content) {
        File file = new File(path.toString());
        try (FileOutputStream fop = new FileOutputStream(file);){
            if (!file.exists()) {
                file.createNewFile();
            }
            fop.write(content.getBytes());
            fop.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

