/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.soup.project.datamodel.oracle.Annotation;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.AnnotationUtils;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.BlackLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFieldInspector {
    private static final Logger log = LoggerFactory.getLogger(ClassFieldInspector.class);
    private final Map<String, FieldInfo> fieldTypesFieldInfo = new HashMap<String, FieldInfo>();

    public ClassFieldInspector(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(this.getAllFields(clazz).values());
        List<Field> declaredFields = Arrays.asList(clazz.getDeclaredFields());
        HashMap<String, Field> inaccessibleFields = new HashMap<String, Field>();
        for (Field field : fields) {
            if (BlackLists.isClassMethodBlackListed(clazz, field.getName()) || BlackLists.isTypeBlackListed(field.getType())) continue;
            if (Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                ModelField.FIELD_ORIGIN origin = declaredFields.contains(field) ? ModelField.FIELD_ORIGIN.DECLARED : ModelField.FIELD_ORIGIN.INHERITED;
                this.fieldTypesFieldInfo.put(field.getName(), new FieldInfo(FieldAccessorsAndMutators.BOTH, field.getGenericType(), field.getType(), origin, AnnotationUtils.getFieldAnnotations(field, origin.equals((Object)ModelField.FIELD_ORIGIN.INHERITED))));
                continue;
            }
            inaccessibleFields.put(field.getName(), field);
        }
        ArrayList<Method> methods = new ArrayList<Method>(this.getAllMethods(clazz).values());
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(method.getModifiers())) continue;
            String methodName = null;
            FieldAccessorsAndMutators accessorsAndMutators = null;
            if (this.isGetter(method)) {
                methodName = method.getName().substring(3);
                methodName = Introspector.decapitalize(methodName);
                accessorsAndMutators = FieldAccessorsAndMutators.ACCESSOR;
            } else if (this.isBooleanGetter(method)) {
                methodName = method.getName().substring(2);
                methodName = Introspector.decapitalize(methodName);
                accessorsAndMutators = FieldAccessorsAndMutators.ACCESSOR;
            } else if (this.isSetter(method)) {
                methodName = method.getName().substring(3);
                methodName = Introspector.decapitalize(methodName);
                accessorsAndMutators = FieldAccessorsAndMutators.MUTATOR;
            }
            if (methodName == null || BlackLists.isClassMethodBlackListed(clazz, methodName) || BlackLists.isTypeBlackListed(method.getReturnType())) continue;
            if (this.fieldTypesFieldInfo.containsKey(methodName)) {
                FieldInfo info = this.fieldTypesFieldInfo.get(methodName);
                if (accessorsAndMutators == FieldAccessorsAndMutators.ACCESSOR) {
                    if (info.accessorAndMutator == FieldAccessorsAndMutators.MUTATOR) {
                        info.accessorAndMutator = FieldAccessorsAndMutators.BOTH;
                    }
                    if (inaccessibleFields.containsKey(methodName)) continue;
                    info.genericType = method.getGenericReturnType();
                    info.returnType = method.getReturnType();
                    continue;
                }
                if (accessorsAndMutators != FieldAccessorsAndMutators.MUTATOR || info.accessorAndMutator != FieldAccessorsAndMutators.ACCESSOR) continue;
                info.accessorAndMutator = FieldAccessorsAndMutators.BOTH;
                continue;
            }
            ModelField.FIELD_ORIGIN origin = this.getOrigin(methodName, this.getNames(fields), this.getNames(declaredFields));
            Field inaccessibleField = (Field)inaccessibleFields.get(methodName);
            Type genericType = method.getGenericReturnType();
            Class<?> type = method.getReturnType();
            if (inaccessibleField != null) {
                genericType = inaccessibleField.getGenericType();
                type = inaccessibleField.getType();
            }
            this.fieldTypesFieldInfo.put(methodName, new FieldInfo(accessorsAndMutators, genericType, type, origin, AnnotationUtils.getFieldAnnotations(inaccessibleField, origin.equals((Object)ModelField.FIELD_ORIGIN.INHERITED))));
        }
    }

    private boolean isGetter(Method m) {
        String name = m.getName();
        int parameterCount = m.getParameterTypes().length;
        if (parameterCount != 0) {
            return false;
        }
        return name.length() > 3 && name.startsWith("get");
    }

    private boolean isBooleanGetter(Method m) {
        String name = m.getName();
        int parameterCount = m.getParameterTypes().length;
        if (parameterCount != 0) {
            return false;
        }
        return name.length() > 2 && name.startsWith("is") && (Boolean.class.isAssignableFrom(m.getReturnType()) || Boolean.TYPE == m.getReturnType());
    }

    private boolean isSetter(Method m) {
        String name = m.getName();
        int parameterCount = m.getParameterTypes().length;
        if (parameterCount != 1) {
            return false;
        }
        return name.length() > 3 && name.startsWith("set");
    }

    private List<String> getNames(List<Field> fields) {
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields) {
            names.add(field.getName());
        }
        return names;
    }

    private ModelField.FIELD_ORIGIN getOrigin(String methodName, List<String> fields, List<String> declaredFields) {
        if (declaredFields.contains(methodName)) {
            return ModelField.FIELD_ORIGIN.DECLARED;
        }
        if (fields.contains(methodName)) {
            return ModelField.FIELD_ORIGIN.INHERITED;
        }
        return ModelField.FIELD_ORIGIN.DELEGATED;
    }

    public Set<String> getFieldNames() {
        return this.fieldTypesFieldInfo.keySet();
    }

    public Map<String, FieldInfo> getFieldTypesFieldInfo() {
        return this.fieldTypesFieldInfo;
    }

    private Map<String, Field> getAllFields(Class<?> type) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                fields.put(f.getName(), f);
            }
        }
        return fields;
    }

    private Map<String, Method> getAllMethods(Class<?> type) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                methods.put(m.getName(), m);
            }
        }
        return methods;
    }

    public static class FieldInfo {
        private FieldAccessorsAndMutators accessorAndMutator;
        private Type genericType;
        private Class<?> returnType;
        private ModelField.FIELD_ORIGIN origin;
        private Set<Annotation> annotations;

        private FieldInfo(FieldAccessorsAndMutators accessorAndMutator, Type genericType, Class<?> returnType, ModelField.FIELD_ORIGIN origin, Set<Annotation> annotations) {
            this.accessorAndMutator = accessorAndMutator;
            this.genericType = genericType;
            this.returnType = returnType;
            this.origin = origin;
            this.annotations = annotations;
        }

        public FieldAccessorsAndMutators getAccessorAndMutator() {
            return this.accessorAndMutator;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public ModelField.FIELD_ORIGIN getOrigin() {
            return this.origin;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }
    }
}

