/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.descr;

import java.util.List;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassOrInterfaceTypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.DimensionDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasClassOrInterfaceType;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasDimensions;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasPrimitiveType;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.PrimitiveTypeDescr;

public class TypeDescr
extends ElementDescriptor
implements HasClassOrInterfaceType,
HasPrimitiveType,
HasDimensions {
    public TypeDescr() {
        super(ElementDescriptor.ElementType.TYPE);
    }

    public TypeDescr(String text, int start, int stop) {
        this(text, start, stop, -1, -1);
    }

    public TypeDescr(String text, int start, int stop, int line, int position) {
        super(ElementDescriptor.ElementType.TYPE, text, start, stop, line, position);
    }

    public boolean isPrimitiveType() {
        return this.getPrimitiveType() != null;
    }

    public boolean isClassOrInterfaceType() {
        return this.getClassOrInterfaceType() != null;
    }

    public boolean isVoidType() {
        return this.getVoidType() != null;
    }

    @Override
    public ClassOrInterfaceTypeDescr getClassOrInterfaceType() {
        return (ClassOrInterfaceTypeDescr)this.getElements().getFirst(ElementDescriptor.ElementType.CLASS_OR_INTERFACE_TYPE);
    }

    @Override
    public void setClassOrInterfaceType(ClassOrInterfaceTypeDescr classOrInterfaceType) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.CLASS_OR_INTERFACE_TYPE);
        this.getElements().add(classOrInterfaceType);
    }

    @Override
    public PrimitiveTypeDescr getPrimitiveType() {
        return (PrimitiveTypeDescr)this.getElements().getFirst(ElementDescriptor.ElementType.PRIMITIVE_TYPE);
    }

    @Override
    public void setPrimitiveType(PrimitiveTypeDescr primitiveType) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.PRIMITIVE_TYPE);
        this.getElements().add(primitiveType);
    }

    public void setVoidType(JavaTokenDescr voidToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_VOID);
        this.getElements().add(voidToken);
    }

    public JavaTokenDescr getVoidType() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_VOID);
    }

    @Override
    public int getDimensionsCount() {
        List<ElementDescriptor> dimensions = this.getElements().getElementsByType(ElementDescriptor.ElementType.DIMENSION);
        return dimensions.size();
    }

    @Override
    public TypeDescr addDimension(DimensionDescr dimensionDescr) {
        this.getElements().add(dimensionDescr);
        return this;
    }

    public String getName() {
        if (this.isPrimitiveType()) {
            return this.getPrimitiveType().getName();
        }
        if (this.isClassOrInterfaceType()) {
            return this.getClassOrInterfaceType().getClassName();
        }
        if (this.isVoidType()) {
            return this.getVoidType().getText();
        }
        return null;
    }
}

