/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.fields.shared.fieldTypes.basic;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.jboss.errai.common.client.api.Assert;
import org.kie.workbench.common.forms.fields.shared.FieldProvider;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.TypeInfo;

public abstract class BasicTypeFieldProvider<FIELD extends FieldDefinition>
implements FieldProvider<FIELD> {
    protected List<String> supportedTypes = new ArrayList<String>();

    @PostConstruct
    protected void registerFields() {
        this.doRegisterFields();
    }

    public abstract int getPriority();

    protected abstract void doRegisterFields();

    public String[] getSupportedTypes() {
        return this.supportedTypes.toArray(new String[this.supportedTypes.size()]);
    }

    protected void registerPropertyType(Class type) {
        this.registerPropertyType(type.getName());
    }

    protected void registerPropertyType(String type) {
        Assert.notNull((String)"Type cannot be null", (Object)type);
        this.supportedTypes.add(type);
    }

    @Override
    public FIELD getFieldByType(TypeInfo typeInfo) {
        if (typeInfo.getType() == null) {
            return this.getDefaultField();
        }
        if (this.isSupported(typeInfo)) {
            return this.createFieldByType(typeInfo);
        }
        return null;
    }

    public abstract FIELD createFieldByType(TypeInfo var1);

    @Override
    public boolean isCompatible(FieldDefinition field) {
        Assert.notNull((String)"Field cannot be null", (Object)field);
        if (this.getFieldType().equals(field.getFieldType().getClass())) {
            return true;
        }
        return this.isSupported(field.getFieldTypeInfo());
    }

    public boolean isSupported(TypeInfo typeInfo) {
        for (String type : this.getSupportedTypes()) {
            if (!type.equals(typeInfo.getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Class clazz) {
        return this.supportedTypes.contains(clazz.getName());
    }
}

