/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.forms.fields.shared.MultipleValueFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.BasicTypeFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.AbstractMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.MultipleInputFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.BooleanMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.CharacterMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.DateMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.DecimalMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.IntegerMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.StringMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.model.FieldType;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.TypeKind;

@Dependent
public class MultipleInputProvider
extends BasicTypeFieldProvider<AbstractMultipleInputFieldDefinition>
implements MultipleValueFieldProvider<AbstractMultipleInputFieldDefinition> {
    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    protected void doRegisterFields() {
        this.registerPropertyType(BigInteger.class);
        this.registerPropertyType(Byte.class);
        this.registerPropertyType(Integer.class);
        this.registerPropertyType(Long.class);
        this.registerPropertyType(Short.class);
        this.registerPropertyType(BigDecimal.class);
        this.registerPropertyType(Double.class);
        this.registerPropertyType(Float.class);
        this.registerPropertyType(Date.class);
        this.registerPropertyType("java.time.LocalDate");
        this.registerPropertyType("java.time.LocalDateTime");
        this.registerPropertyType("java.time.LocalTime");
        this.registerPropertyType("java.time.OffsetDateTime");
        this.registerPropertyType(Character.class);
        this.registerPropertyType(String.class);
        this.registerPropertyType(Boolean.class);
    }

    @Override
    public AbstractMultipleInputFieldDefinition createFieldByType(TypeInfo typeInfo) {
        if (typeInfo.getType().equals((Object)TypeKind.BASE) && typeInfo.isMultiple()) {
            if (typeInfo.getClassName().equals(Boolean.class.getName())) {
                return new BooleanMultipleInputFieldDefinition();
            }
            if (typeInfo.getClassName().equals(Character.class.getName())) {
                return new CharacterMultipleInputFieldDefinition();
            }
            if (typeInfo.getClassName().equals(String.class.getName())) {
                return new StringMultipleInputFieldDefinition();
            }
            if (typeInfo.getClassName().equals(BigInteger.class.getName()) || typeInfo.getClassName().equals(Byte.class.getName()) || typeInfo.getClassName().equals(Integer.class.getName()) || typeInfo.getClassName().equals(Long.class.getName()) || typeInfo.getClassName().equals(Short.class.getName())) {
                return new IntegerMultipleInputFieldDefinition();
            }
            if (typeInfo.getClassName().equals(BigDecimal.class.getName()) || typeInfo.getClassName().equals(Double.class.getName()) || typeInfo.getClassName().equals(Float.class.getName())) {
                return new DecimalMultipleInputFieldDefinition();
            }
            if (typeInfo.getClassName().equals(Date.class.getName()) || typeInfo.getClassName().equals("java.time.LocalDate") || typeInfo.getClassName().equals("java.time.LocalDateTime") || typeInfo.getClassName().equals("java.time.LocalTime") || typeInfo.getClassName().equals("java.time.OffsetDateTime")) {
                return new DateMultipleInputFieldDefinition();
            }
        }
        return null;
    }

    @Override
    public Class<? extends FieldType> getFieldType() {
        return MultipleInputFieldType.class;
    }

    @Override
    public String getFieldTypeName() {
        return MultipleInputFieldType.NAME;
    }

    @Override
    public AbstractMultipleInputFieldDefinition getDefaultField() {
        return new StringMultipleInputFieldDefinition();
    }

    @Override
    public boolean isSupported(TypeInfo typeInfo) {
        if (!typeInfo.getType().equals((Object)TypeKind.BASE) || !typeInfo.isMultiple()) {
            return false;
        }
        return super.isSupported(typeInfo);
    }
}

