/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index.directory;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene62.Lucene62Codec;
import org.apache.lucene.index.IndexWriterConfig;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryType;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.model.KCluster;

public class DirectoryFactory
implements LuceneIndexFactory {
    private static final String REPOSITORIES_ROOT_DIR = ".index";
    private final Map<KCluster, LuceneIndex> clusters = new ConcurrentHashMap<KCluster, LuceneIndex>();
    private final DirectoryType type;
    private final Analyzer analyzer;

    public DirectoryFactory(DirectoryType type, Analyzer analyzer) {
        this(type, analyzer, DirectoryFactory.defaultHostingDir());
    }

    public DirectoryFactory(DirectoryType type, Analyzer analyzer, File hostingDir) {
        this.analyzer = analyzer;
        this.type = type;
        this.listFiles(hostingDir).filter(file -> file.isDirectory()).flatMap(file -> this.listFiles((File)file)).map(file -> new KClusterImpl(DirectoryFactory.clusterIdOf(file))).forEach(cluster -> this.clusters.put((KCluster)cluster, type.newIndex((KCluster)cluster, this.newConfig(analyzer))));
    }

    private static String clusterIdOf(File file) {
        return file.getParentFile().getName() + "/" + file.getName();
    }

    private Stream<File> listFiles(File hostingDir) {
        File[] files = hostingDir.listFiles();
        return files == null ? Stream.empty() : Arrays.stream(files);
    }

    public static File defaultHostingDir() {
        String value = System.getProperty("org.uberfire.metadata.index.dir");
        if (value == null || value.trim().isEmpty()) {
            return new File(REPOSITORIES_ROOT_DIR);
        }
        return new File(value.trim(), REPOSITORIES_ROOT_DIR);
    }

    private IndexWriterConfig newConfig(Analyzer analyzer) {
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        Lucene62Codec codec = new Lucene62Codec(){

            public PostingsFormat getPostingsFormatForField(String field) {
                if (field.equals("id")) {
                    return PostingsFormat.forName((String)"Memory");
                }
                return PostingsFormat.forName((String)"Lucene50");
            }
        };
        config.setCodec((Codec)codec);
        return config;
    }

    @Override
    public LuceneIndex newCluster(KCluster kcluster) {
        PortablePreconditions.checkCondition((String)"Cluster already exists", (!this.clusters.containsKey(PortablePreconditions.checkNotNull((String)"kcluster", (Object)kcluster)) ? 1 : 0) != 0);
        LuceneIndex newIndex = this.type.newIndex(kcluster, this.newConfig(this.analyzer));
        this.clusters.put(kcluster, newIndex);
        return newIndex;
    }

    @Override
    public void remove(KCluster cluster) {
        this.clusters.remove(cluster);
    }

    @Override
    public Map<? extends KCluster, ? extends LuceneIndex> getIndexes() {
        return Collections.unmodifiableMap(this.clusters);
    }

    public synchronized void dispose() {
        for (LuceneIndex luceneIndex : this.clusters.values()) {
            luceneIndex.dispose();
        }
    }
}

