/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQueries;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindAllChangeImpactQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RefactoringQueryServiceImpl
implements RefactoringQueryService {
    private MetadataConfig config;
    private NamedQueries namedQueries;
    private PageResponse<RefactoringPageRow> emptyResponse;

    public RefactoringQueryServiceImpl() {
    }

    @Inject
    public RefactoringQueryServiceImpl(@Named(value="luceneConfig") MetadataConfig config, NamedQueries namedQueries) {
        this.config = (MetadataConfig)PortablePreconditions.checkNotNull((String)"config", (Object)config);
        this.namedQueries = (NamedQueries)PortablePreconditions.checkNotNull((String)"namedQueries", (Object)namedQueries);
    }

    @PostConstruct
    public void init() {
        this.emptyResponse = new PageResponse();
        this.emptyResponse.setPageRowList(Collections.emptyList());
        this.emptyResponse.setStartRowIndex(0);
        this.emptyResponse.setTotalRowSize(0);
        this.emptyResponse.setLastPage(true);
        this.emptyResponse.setTotalRowSizeExact(true);
    }

    public Set<String> getQueries() {
        return this.namedQueries.getQueries();
    }

    public int queryHitCount(RefactoringPageRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        String queryName = (String)PortablePreconditions.checkNotNull((String)"queryName", (Object)request.getQueryName());
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        namedQuery.validateTerms(request.getQueryTerms());
        Query query = namedQuery.toQuery(request.getQueryTerms());
        Sort sort = namedQuery.getSortOrder();
        try {
            List<KObject> found = this.config.getIndexProvider().findByQuery(Collections.EMPTY_LIST, query, sort, 0);
            if (request.distinctResults().booleanValue()) {
                found = this.distinct(found);
            }
            return found.size();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
    }

    public List<KObject> distinct(List<KObject> found) {
        return found.stream().filter(RefactoringQueryServiceImpl.distinctByKey(RefactoringQueryServiceImpl::generateUniqueIdentifierForKObject)).collect(Collectors.toList());
    }

    private static String generateUniqueIdentifierForKObject(KObject kObject) {
        return kObject.getClusterId() + kObject.getKey();
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public PageResponse<RefactoringPageRow> query(RefactoringPageRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        String queryName = (String)PortablePreconditions.checkNotNull((String)"queryName", (Object)request.getQueryName());
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        namedQuery.validateTerms(request.getQueryTerms());
        Query query = namedQuery.toQuery(request.getQueryTerms());
        Sort sort = namedQuery.getSortOrder();
        int pageSize = request.getPageSize();
        int startIndex = request.getStartRowIndex();
        List<KObject> kObjects = this.search(query, sort, () -> startIndex, numHits -> numHits - startIndex > pageSize ? pageSize : numHits - startIndex, request.distinctResults(), new ClusterSegment[0]);
        if (!kObjects.isEmpty()) {
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(pageSize, startIndex, new ArrayList<KObject>(kObjects));
        }
        return this.emptyResponse;
    }

    public List<RefactoringPageRow> query(String queryName, Set<ValueIndexTerm> queryTerms) {
        PortablePreconditions.checkNotNull((String)"queryName", (Object)queryName);
        PortablePreconditions.checkNotNull((String)"queryTerms", queryTerms);
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        namedQuery.validateTerms(queryTerms);
        Query query = namedQuery.toQuery(queryTerms);
        Sort sort = namedQuery.getSortOrder();
        List<KObject> kObjects = this.search(query, sort, () -> 0, numHits -> numHits, false, new ClusterSegment[0]);
        if (!kObjects.isEmpty()) {
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(kObjects);
        }
        return Collections.emptyList();
    }

    private List<KObject> search(Query query, Sort sort, Supplier<Integer> startIndexSupplier, IntFunction<Integer> numOfHitsToReturnSupplier, boolean distinct, ClusterSegment ... clusterSegments) {
        try {
            List indices = Arrays.stream(clusterSegments).map(clusterSegment -> clusterSegment.getClusterId()).collect(Collectors.toList());
            List<KObject> found = this.config.getIndexProvider().findByQuery(indices, query, sort, 0);
            if (distinct) {
                found = this.distinct(found);
            }
            int startIndex = startIndexSupplier.get();
            int numOfHitsToReturn = numOfHitsToReturnSupplier.apply(found.size());
            return found.subList(startIndex, startIndex + numOfHitsToReturn);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
    }

    public PageResponse<RefactoringPageRow> queryToPageResponse(QueryOperationRequest queryOpRequest) {
        RefactoringPageRequest request = this.convertToRefactoringPageRequest(queryOpRequest);
        PageResponse<RefactoringPageRow> response = this.query(request);
        return response;
    }

    public List<RefactoringPageRow> queryToList(QueryOperationRequest queryOpRequest) {
        RefactoringPageRequest request = this.convertToRefactoringPageRequest(queryOpRequest);
        List<RefactoringPageRow> response = this.query(request.getQueryName(), request.getQueryTerms());
        return response;
    }

    private RefactoringPageRequest convertToRefactoringPageRequest(QueryOperationRequest refOpRequest) {
        String branchName;
        String projectRootPathURI;
        RefactoringPageRequest request = new RefactoringPageRequest(FindAllChangeImpactQuery.NAME, new HashSet(), refOpRequest.getStartRowIndex(), refOpRequest.getPageSize());
        request.getQueryTerms().addAll(refOpRequest.getQueryTerms());
        String projectName = refOpRequest.getModuleName();
        if (projectName != null && projectName != QueryOperationRequest.ALL) {
            ValueModuleNameIndexTerm valueIndexTerm = new ValueModuleNameIndexTerm(projectName);
            HashSet<ValueModuleNameIndexTerm> queryTerms = new HashSet<ValueModuleNameIndexTerm>(1);
            queryTerms.add(valueIndexTerm);
            request.getQueryTerms().addAll(queryTerms);
        }
        if ((projectRootPathURI = refOpRequest.getModuleRootPathURI()) != null && projectRootPathURI != QueryOperationRequest.ALL) {
            ValueModuleRootPathIndexTerm valueIndexTerm = new ValueModuleRootPathIndexTerm(projectRootPathURI);
            HashSet<ValueModuleRootPathIndexTerm> queryTerms = new HashSet<ValueModuleRootPathIndexTerm>(1);
            queryTerms.add(valueIndexTerm);
            request.getQueryTerms().addAll(queryTerms);
        }
        if ((branchName = refOpRequest.getBranchName()) != null && branchName != QueryOperationRequest.ALL) {
            ValueBranchNameIndexTerm valueIndexTerm = new ValueBranchNameIndexTerm(branchName);
            HashSet<ValueBranchNameIndexTerm> queryTerms = new HashSet<ValueBranchNameIndexTerm>(1);
            queryTerms.add(valueIndexTerm);
            request.getQueryTerms().addAll(queryTerms);
        }
        return request;
    }
}

