/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsObject;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLElement extends Element {
  @JsType
  public interface AttachShadowOptionsType {
    @JsProperty
    String getMode();

    @JsProperty
    void setMode(String mode);
  }

  @JsFunction
  public interface AttachedCallbackFn {
    Object onInvoke();
  }

  @JsFunction
  public interface ConnectedCallbackFn {
    Object onInvoke();
  }

  @JsFunction
  public interface CreatedCallbackFn {
    Object onInvoke();
  }

  @JsFunction
  public interface DetachedCallbackFn {
    Object onInvoke();
  }

  @JsFunction
  public interface DisconnectedCallbackFn {
    Object onInvoke();
  }

  public static String[] observedAttributes;
  public AttachedCallbackFn attachedCallback;
  public String className;
  public ConnectedCallbackFn connectedCallback;
  public Element contextMenu;
  public CreatedCallbackFn createdCallback;
  public JsPropertyMap<String> dataset;
  public DetachedCallbackFn detachedCallback;
  public String dir;
  public DisconnectedCallbackFn disconnectedCallback;
  public boolean draggable;
  public JsObject dropzone;
  public boolean hidden;
  public String id;
  public String lang;
  public double offsetHeight;
  public double offsetLeft;
  public Element offsetParent;
  public double offsetTop;
  public double offsetWidth;
  public ShadowRoot shadowRoot;
  public boolean spellcheck;
  public CSSStyleDeclaration style;
  public double tabIndex;
  public String title;

  public native Object adoptedCallback(Document oldDocument, Document newDocument);

  public native ShadowRoot attachShadow(AttachShadowOptionsType options);

  public native Object attributeChangedCallback(
      String attributeName, String oldValue, String newValue, String namespace);

  public native ShadowRoot createShadowRoot();

  public native NodeList<Node> getDestinationInsertionPoints();

  public native NodeList<Element> getElementsByClassName(String classNames);

  public native ShadowRoot webkitCreateShadowRoot();
}
