/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.soup.project.datamodel.oracle.Annotation;
import org.kie.soup.project.datamodel.oracle.MethodInfo;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.model.LazyModelField;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleIncrementalPayload;
import org.kie.workbench.common.services.datamodel.util.SortHelper;

public class DataModelOracleUtilities {
    public static String[] getFactTypes(ModuleDataModelOracle oracle) {
        List packageNames = oracle.getModulePackageNames();
        Map modelFields = oracle.getModuleModelFields();
        ArrayList<String> types = new ArrayList<String>();
        for (String type : modelFields.keySet()) {
            int beginIndex = type.lastIndexOf(46);
            if (beginIndex < 0) {
                types.add(type);
                continue;
            }
            String substring = type.substring(0, beginIndex);
            if (!packageNames.contains(substring)) continue;
            types.add(type);
        }
        Collections.sort(types, SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
        return types.toArray(new String[types.size()]);
    }

    public static String[] getFieldNames(ModuleDataModelOracle oracle, String fullyQualifiedClassName) {
        ModelField[] modelFields = (ModelField[])oracle.getModuleModelFields().get(fullyQualifiedClassName);
        if (modelFields == null) {
            return new String[0];
        }
        String[] fieldNames = new String[modelFields.length];
        for (int i = 0; i < modelFields.length; ++i) {
            fieldNames[i] = modelFields[i].getName();
        }
        Arrays.sort(fieldNames, SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
        return fieldNames;
    }

    public static String getSuperType(ModuleDataModelOracle oracle, String fullyQualifiedClassName) {
        List superTypes = (List)oracle.getModuleSuperTypes().get(fullyQualifiedClassName);
        if (superTypes != null && superTypes.size() > 0) {
            return (String)superTypes.get(0);
        }
        return null;
    }

    public static Set<Annotation> getTypeAnnotations(ModuleDataModelOracle oracle, String fullyQualifiedClassName) {
        Map typeAnnotations = oracle.getModuleTypeAnnotations();
        if (!typeAnnotations.containsKey(fullyQualifiedClassName)) {
            return Collections.emptySet();
        }
        return (Set)typeAnnotations.get(fullyQualifiedClassName);
    }

    public static Map<String, Set<Annotation>> getTypeFieldsAnnotations(ModuleDataModelOracle oracle, String fullyQualifiedClassName) {
        Map typeFieldsAnnotations = oracle.getModuleTypeFieldsAnnotations();
        if (!typeFieldsAnnotations.containsKey(fullyQualifiedClassName)) {
            return Collections.emptyMap();
        }
        return (Map)typeFieldsAnnotations.get(fullyQualifiedClassName);
    }

    public static String getFieldClassName(ModuleDataModelOracle oracle, String fullyQualifiedClassName, String fieldName) {
        ModelField field = DataModelOracleUtilities.getField(oracle, fullyQualifiedClassName, fieldName);
        return field == null ? null : field.getClassName();
    }

    private static ModelField getField(ModuleDataModelOracle oracle, String fullyQualifiedClassName, String fieldName) {
        String shortName = DataModelOracleUtilities.getFactNameFromType(oracle, fullyQualifiedClassName);
        ModelField[] fields = (ModelField[])oracle.getModuleModelFields().get(shortName);
        if (fields == null) {
            return null;
        }
        for (ModelField modelField : fields) {
            if (!modelField.getName().equals(fieldName)) continue;
            return modelField;
        }
        return null;
    }

    private static String getFactNameFromType(ModuleDataModelOracle oracle, String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            return null;
        }
        if (oracle.getModuleModelFields().containsKey(fullyQualifiedClassName)) {
            return fullyQualifiedClassName;
        }
        for (Map.Entry entry : oracle.getModuleModelFields().entrySet()) {
            for (ModelField mf : (ModelField[])entry.getValue()) {
                if (!"this".equals(mf.getName()) || !fullyQualifiedClassName.equals(mf.getClassName())) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public static String getParametricFieldType(ModuleDataModelOracle oracle, String fullyQualifiedClassName, String fieldName) {
        String qualifiedFactFieldName = fullyQualifiedClassName + "#" + fieldName;
        return (String)oracle.getModuleFieldParametersType().get(qualifiedFactFieldName);
    }

    public static TypeSource getTypeSource(ModuleDataModelOracle oracle, String fullyQualifiedClassName) {
        return (TypeSource)oracle.getModuleTypeSources().get(fullyQualifiedClassName);
    }

    public static void populateDataModel(PackageDataModelOracle oracle, PackageDataModelOracleBaselinePayload dataModel, Set<String> usedFullyQualifiedClassNames) {
        dataModel.setModuleName(oracle.getModuleName());
        dataModel.setPackageName(oracle.getPackageName());
        dataModel.setModelFields(DataModelOracleUtilities.setupModelFields(usedFullyQualifiedClassNames, oracle.getModuleModelFields(), oracle.getPackageGlobals()));
        dataModel.setFieldParametersType(DataModelOracleUtilities.filterFieldParametersTypes(usedFullyQualifiedClassNames, oracle.getModuleFieldParametersType()));
        dataModel.setEventTypes(DataModelOracleUtilities.filterEventTypes(usedFullyQualifiedClassNames, oracle.getModuleEventTypes()));
        dataModel.setTypeSources(DataModelOracleUtilities.filterTypeSources(usedFullyQualifiedClassNames, oracle.getModuleTypeSources()));
        dataModel.setSuperTypes(DataModelOracleUtilities.filterSuperTypes(usedFullyQualifiedClassNames, oracle.getModuleSuperTypes()));
        dataModel.setTypeAnnotations(DataModelOracleUtilities.filterTypeAnnotations(usedFullyQualifiedClassNames, oracle.getModuleTypeAnnotations()));
        dataModel.setTypeFieldsAnnotations(DataModelOracleUtilities.filterTypeFieldsAnnotations(usedFullyQualifiedClassNames, oracle.getModuleTypeFieldsAnnotations()));
        dataModel.setJavaEnumDefinitions(oracle.getModuleJavaEnumDefinitions());
        dataModel.setWorkbenchEnumDefinitions(oracle.getPackageWorkbenchDefinitions());
        dataModel.setMethodInformation(DataModelOracleUtilities.filterMethodInformation(usedFullyQualifiedClassNames, oracle.getModuleMethodInformation()));
        dataModel.setCollectionTypes(DataModelOracleUtilities.filterCollectionTypes(usedFullyQualifiedClassNames, oracle.getModuleCollectionTypes()));
        dataModel.setAllPackageElements(oracle.getAllExtensions());
        dataModel.setGlobalTypes(oracle.getPackageGlobals());
        dataModel.setPackageNames(oracle.getModulePackageNames());
    }

    public static void populateDataModel(PackageDataModelOracle oracle, PackageDataModelOracleIncrementalPayload dataModel, String usedFullyQualifiedClassName) {
        HashSet<String> usedFullyQualifiedClassNames = new HashSet<String>();
        usedFullyQualifiedClassNames.add(usedFullyQualifiedClassName);
        dataModel.setModelFields(DataModelOracleUtilities.filterModelFields(usedFullyQualifiedClassNames, oracle.getModuleModelFields()));
        dataModel.setFieldParametersType(DataModelOracleUtilities.filterFieldParametersTypes(usedFullyQualifiedClassNames, oracle.getModuleFieldParametersType()));
        dataModel.setEventTypes(DataModelOracleUtilities.filterEventTypes(usedFullyQualifiedClassNames, oracle.getModuleEventTypes()));
        dataModel.setTypeSources(DataModelOracleUtilities.filterTypeSources(usedFullyQualifiedClassNames, oracle.getModuleTypeSources()));
        dataModel.setSuperTypes(DataModelOracleUtilities.filterSuperTypes(usedFullyQualifiedClassNames, oracle.getModuleSuperTypes()));
        dataModel.setTypeAnnotations(DataModelOracleUtilities.filterTypeAnnotations(usedFullyQualifiedClassNames, oracle.getModuleTypeAnnotations()));
        dataModel.setTypeFieldsAnnotations(DataModelOracleUtilities.filterTypeFieldsAnnotations(usedFullyQualifiedClassNames, oracle.getModuleTypeFieldsAnnotations()));
        dataModel.setMethodInformation(DataModelOracleUtilities.filterMethodInformation(usedFullyQualifiedClassNames, oracle.getModuleMethodInformation()));
        dataModel.setCollectionTypes(DataModelOracleUtilities.filterCollectionTypes(usedFullyQualifiedClassNames, oracle.getModuleCollectionTypes()));
    }

    private static Map<String, ModelField[]> setupModelFields(Set<String> usedFullyQualifiedClassNames, Map<String, ModelField[]> moduleModelFields, Map<String, String> packageGlobals) {
        HashMap<String, ModelField[]> scopedModelFields = new HashMap<String, ModelField[]>();
        for (Map.Entry<String, ModelField[]> e : moduleModelFields.entrySet()) {
            String mfQualifiedType = e.getKey();
            if (usedFullyQualifiedClassNames.contains(mfQualifiedType)) {
                scopedModelFields.put(mfQualifiedType, e.getValue());
                continue;
            }
            if (packageGlobals.containsValue(mfQualifiedType)) {
                scopedModelFields.put(mfQualifiedType, e.getValue());
                continue;
            }
            scopedModelFields.put(mfQualifiedType, DataModelOracleUtilities.makeLazyProxyModelField(e.getValue()));
        }
        return scopedModelFields;
    }

    private static ModelField[] makeLazyProxyModelField(ModelField[] modelFields) {
        for (ModelField modelField : modelFields) {
            if (!"this".equals(modelField.getName())) continue;
            ModelField[] result = new ModelField[]{new LazyModelField(modelField.getName(), modelField.getClassName(), modelField.getClassType(), modelField.getOrigin(), modelField.getAccessorsAndMutators(), modelField.getType())};
            return result;
        }
        return null;
    }

    private static Map<String, ModelField[]> filterModelFields(Set<String> usedFullyQualifiedClassNames, Map<String, ModelField[]> moduleModelFields) {
        HashMap<String, ModelField[]> scopedModelFields = new HashMap<String, ModelField[]>();
        for (Map.Entry<String, ModelField[]> e : moduleModelFields.entrySet()) {
            String mfQualifiedType = e.getKey();
            ModelField[] mfModelFields = e.getValue();
            if (!DataModelOracleUtilities.isTypeUsed(mfQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedModelFields.put(mfQualifiedType, mfModelFields);
        }
        return scopedModelFields;
    }

    private static Map<String, Boolean> filterCollectionTypes(Set<String> usedFullyQualifiedClassNames, Map<String, Boolean> moduleCollectionTypes) {
        HashMap<String, Boolean> scopedCollectionTypes = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> e : moduleCollectionTypes.entrySet()) {
            String collectionQualifiedType = e.getKey();
            if (!DataModelOracleUtilities.isTypeUsed(collectionQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedCollectionTypes.put(collectionQualifiedType, e.getValue());
        }
        return scopedCollectionTypes;
    }

    private static Map<String, Boolean> filterEventTypes(Set<String> usedFullyQualifiedClassNames, Map<String, Boolean> moduleEventTypes) {
        HashMap<String, Boolean> scopedEventTypes = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> e : moduleEventTypes.entrySet()) {
            String eventQualifiedType = e.getKey();
            if (!DataModelOracleUtilities.isTypeUsed(eventQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedEventTypes.put(eventQualifiedType, e.getValue());
        }
        return scopedEventTypes;
    }

    private static Map<String, TypeSource> filterTypeSources(Set<String> usedFullyQualifiedClassNames, Map<String, TypeSource> moduleTypeSources) {
        HashMap<String, TypeSource> scopedTypeSources = new HashMap<String, TypeSource>();
        for (Map.Entry<String, TypeSource> e : moduleTypeSources.entrySet()) {
            String typeQualifiedType = e.getKey();
            if (!DataModelOracleUtilities.isTypeUsed(typeQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedTypeSources.put(typeQualifiedType, e.getValue());
        }
        return scopedTypeSources;
    }

    private static Map<String, List<String>> filterSuperTypes(Set<String> usedFullyQualifiedClassNames, Map<String, List<String>> moduleSuperTypes) {
        HashMap<String, List<String>> scopedSuperTypes = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : moduleSuperTypes.entrySet()) {
            String typeQualifiedType = e.getKey();
            List<String> superTypeQualifiedTypes = e.getValue();
            if (!DataModelOracleUtilities.isTypeUsed(typeQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedSuperTypes.put(typeQualifiedType, superTypeQualifiedTypes);
        }
        return scopedSuperTypes;
    }

    private static Map<String, Set<Annotation>> filterTypeAnnotations(Set<String> usedFullyQualifiedClassNames, Map<String, Set<Annotation>> moduleTypeAnnotations) {
        HashMap<String, Set<Annotation>> scopedTypeAnnotations = new HashMap<String, Set<Annotation>>();
        for (Map.Entry<String, Set<Annotation>> e : moduleTypeAnnotations.entrySet()) {
            String typeAnnotationQualifiedType = e.getKey();
            if (!DataModelOracleUtilities.isTypeUsed(typeAnnotationQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedTypeAnnotations.put(typeAnnotationQualifiedType, e.getValue());
        }
        return scopedTypeAnnotations;
    }

    private static Map<String, Map<String, Set<Annotation>>> filterTypeFieldsAnnotations(Set<String> usedFullyQualifiedClassNames, Map<String, Map<String, Set<Annotation>>> moduleTypeFieldsAnnotations) {
        HashMap<String, Map<String, Set<Annotation>>> scopedTypeFieldsAnnotations = new HashMap<String, Map<String, Set<Annotation>>>();
        for (Map.Entry<String, Map<String, Set<Annotation>>> e : moduleTypeFieldsAnnotations.entrySet()) {
            String typeAnnotationQualifiedType = e.getKey();
            if (!DataModelOracleUtilities.isTypeUsed(typeAnnotationQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedTypeFieldsAnnotations.put(typeAnnotationQualifiedType, e.getValue());
        }
        return scopedTypeFieldsAnnotations;
    }

    private static Map<String, List<MethodInfo>> filterMethodInformation(Set<String> usedFullyQualifiedClassNames, Map<String, List<MethodInfo>> moduleMethodInformation) {
        HashMap<String, List<MethodInfo>> scopedMethodInformation = new HashMap<String, List<MethodInfo>>();
        for (Map.Entry<String, List<MethodInfo>> e : moduleMethodInformation.entrySet()) {
            String miQualifiedType = e.getKey();
            if (!DataModelOracleUtilities.isTypeUsed(miQualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedMethodInformation.put(miQualifiedType, e.getValue());
        }
        return scopedMethodInformation;
    }

    private static Map<String, String> filterFieldParametersTypes(Set<String> usedFullyQualifiedClassNames, Map<String, String> moduleFieldParametersTypes) {
        HashMap<String, String> scopedFieldParametersType = new HashMap<String, String>();
        for (Map.Entry<String, String> e : moduleFieldParametersTypes.entrySet()) {
            String fieldName = e.getKey();
            String fieldType = e.getValue();
            String fFieldName_QualifiedType = DataModelOracleUtilities.getQualifiedTypeFromEncodedFieldName(fieldName);
            if (!DataModelOracleUtilities.isTypeUsed(fFieldName_QualifiedType, usedFullyQualifiedClassNames)) continue;
            scopedFieldParametersType.put(fieldName, fieldType);
        }
        return scopedFieldParametersType;
    }

    private static String getQualifiedTypeFromEncodedFieldName(String encodedFieldName) {
        String typeName = encodedFieldName;
        int hashIndex = typeName.lastIndexOf("#");
        if (hashIndex != -1) {
            typeName = typeName.substring(0, hashIndex);
        }
        return typeName;
    }

    private static boolean isTypeUsed(String fullyQualifiedClassName, Set<String> usedFullyQualifiedClassNames) {
        return usedFullyQualifiedClassNames.contains(fullyQualifiedClassName);
    }
}

