/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import com.google.protobuf.ExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleCache;
import org.drools.compiler.kie.builder.impl.KieModuleCacheHelper;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.common.ResourceProvider;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.Drools;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.RuleTemplateModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.io.ResourceTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieModule
implements InternalKieModule,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractKieModule.class);
    private final transient Map<String, KnowledgeBuilder> kBuilders = new HashMap<String, KnowledgeBuilder>();
    private final transient Map<String, Results> resultsCache = new HashMap<String, Results>();
    protected ReleaseId releaseId;
    private transient KieModuleModel kModuleModel;
    private Map<ReleaseId, InternalKieModule> kieDependencies;
    protected Map<String, InternalKieModule.CompilationCache> compilationCache = new HashMap<String, InternalKieModule.CompilationCache>();
    private Map<String, TypeMetaInfo> typesMetaInfo;
    private transient Map<String, ResourceConfiguration> resourceConfigurationCache = new HashMap<String, ResourceConfiguration>();
    protected transient PomModel pomModel;
    private Collection<ReleaseId> unresolvedDependencies;

    public AbstractKieModule() {
    }

    public AbstractKieModule(ReleaseId releaseId, KieModuleModel kModuleModel) {
        this.releaseId = releaseId;
        this.kModuleModel = kModuleModel;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.kModuleModel;
    }

    @Override
    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.kieDependencies == null ? Collections.emptyMap() : this.kieDependencies;
    }

    @Override
    public void addKieDependency(InternalKieModule dependency) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new HashMap<ReleaseId, InternalKieModule>();
        }
        this.kieDependencies.put(dependency.getReleaseId(), dependency);
    }

    @Override
    public Collection<ReleaseId> getJarDependencies(DependencyFilter filter) {
        if (this.pomModel == null) {
            this.getPomModel();
        }
        Collection<ReleaseId> deps = null;
        if (this.pomModel != null) {
            deps = ReleaseIdImpl.adaptAll(this.pomModel.getDependencies(filter));
        }
        return deps == null ? Collections.emptyList() : deps;
    }

    @Override
    public Collection<ReleaseId> getUnresolvedDependencies() {
        return this.unresolvedDependencies == null ? Collections.emptyList() : this.unresolvedDependencies;
    }

    @Override
    public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
        this.unresolvedDependencies = unresolvedDependencies;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.kBuilders.isEmpty() ? null : ((KnowledgeBuilderImpl)this.kBuilders.values().iterator().next()).getRootClassLoader();
    }

    @Override
    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.kBuilders.get(kieBaseName);
    }

    @Override
    public Collection<KiePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        KnowledgeBuilder kbuilder = this.kBuilders.get(kieBaseName);
        return kbuilder != null ? kbuilder.getKnowledgePackages() : null;
    }

    @Override
    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.kBuilders.put(kieBaseName, kbuilder);
    }

    @Override
    public Map<String, Results> getKnowledgeResultsCache() {
        return this.resultsCache;
    }

    @Override
    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.resultsCache.put(kieBaseName, results);
    }

    @Override
    public Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            classes.put(fileName, this.getBytes(fileName));
        }
        return classes;
    }

    private Map<String, TypeMetaInfo> getTypesMetaInfo() {
        byte[] bytes;
        if (this.typesMetaInfo == null && (bytes = this.getBytes("META-INF/kmodule.info")) != null) {
            this.typesMetaInfo = KieModuleMetaInfo.unmarshallMetaInfos((String)new String(bytes, IoUtils.UTF8_CHARSET)).getTypeMetaInfos();
        }
        return this.typesMetaInfo;
    }

    @Override
    public InternalKnowledgeBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        KnowledgeBuilder kbuilder;
        Collection<KiePackage> pkgs = this.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (pkgs == null && (kbuilder = kieProject.buildKnowledgePackages(kBaseModel, messages)).hasErrors()) {
            return null;
        }
        pkgs = this.getKnowledgePackagesForKieBase(kBaseModel.getName());
        AbstractKieModule.checkStreamMode(kBaseModel, conf, pkgs);
        ClassLoader cl = kieProject.getClassLoader();
        if (conf == null) {
            conf = this.getKnowledgeBaseConfiguration(kBaseModel, cl);
        } else if (conf instanceof RuleBaseConfiguration) {
            ((RuleBaseConfiguration)conf).setClassLoader(cl);
        }
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase((String)kBaseModel.getName(), (KieBaseConfiguration)conf);
        kBase.addPackages(pkgs);
        return kBase;
    }

    public static void checkStreamMode(KieBaseModelImpl kBaseModel, KieBaseConfiguration conf, Collection<? extends KiePackage> pkgs) {
        if (kBaseModel.getEventProcessingMode() == EventProcessingOption.CLOUD && (conf == null || conf.getOption(EventProcessingOption.class) == EventProcessingOption.CLOUD)) {
            for (KiePackage kiePackage : pkgs) {
                if (!((KnowledgePackageImpl)kiePackage).needsStreamMode()) continue;
                throw new RuntimeException("The requested KieBase \"" + kBaseModel.getName() + "\" has been set to run in CLOUD mode but requires features only available in STREAM mode");
            }
        }
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{cl});
        kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
        kbConf.setOption((KieBaseOption)kBaseModel.getDeclarativeAgenda());
        return kbConf;
    }

    @Override
    public KnowledgeBuilderConfiguration getBuilderConfiguration(KieBaseModel kBaseModel, ClassLoader classLoader) {
        KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(classLoader);
        AbstractKieModule.setModelPropsOnConf((KieBaseModelImpl)kBaseModel, pconf);
        return pconf;
    }

    static void setModelPropsOnConf(KieBaseModelImpl kBaseModel, KnowledgeBuilderConfigurationImpl pconf) {
        KieModuleModel kModuleModel = kBaseModel.getKModule();
        for (Map.Entry entry : kModuleModel.getConfigurationProperties().entrySet()) {
            pconf.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public final boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName) {
        return this.addResourceToCompiler(ckbuilder, kieBaseModel, fileName, null);
    }

    @Override
    public final boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, ResourceChangeSet rcs) {
        ResourceConfiguration conf = this.getResourceConfiguration(fileName);
        Resource resource = this.getResource(fileName);
        if (resource != null) {
            ResourceType resourceType;
            ResourceType resourceType2 = resourceType = conf instanceof ResourceConfigurationImpl && ((ResourceConfigurationImpl)conf).getResourceType() != null ? ((ResourceConfigurationImpl)conf).getResourceType() : ResourceType.determineResourceType((String)fileName);
            if (resourceType == ResourceType.DTABLE && conf instanceof DecisionTableConfiguration) {
                for (RuleTemplateModel template : kieBaseModel.getRuleTemplates()) {
                    Resource templateResource;
                    if (!template.getDtable().equals(fileName) || (templateResource = this.getResource(template.getTemplate())) == null) continue;
                    ((DecisionTableConfiguration)conf).addRuleTemplateConfiguration(templateResource, template.getRow(), template.getCol());
                }
            }
            if (conf == null) {
                ckbuilder.add(resource, resourceType, rcs);
            } else {
                ckbuilder.add(resource, resourceType, conf, rcs);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        return bytes != null && bytes.length > 0;
    }

    @Override
    public Resource getResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        if (bytes != null && bytes.length > 0) {
            return ResourceFactory.newByteArrayResource((byte[])bytes).setSourcePath(fileName);
        }
        return null;
    }

    @Override
    public ResourceConfiguration getResourceConfiguration(String fileName) {
        int lastDot;
        ResourceConfiguration conf = this.resourceConfigurationCache.get(fileName);
        if (conf != null) {
            return conf;
        }
        if (this.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(this.getBytes(fileName + ".properties")));
            }
            catch (IOException e) {
                log.error("Error loading resource configuration from file: " + fileName + ".properties");
            }
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        } else if (ResourceType.DTABLE.matchesExtension(fileName) && (lastDot = fileName.lastIndexOf(46)) >= 0 && fileName.length() > lastDot + 1) {
            String extension = fileName.substring(lastDot + 1);
            Properties prop = new Properties();
            prop.setProperty("kie.resource.conf.class", DecisionTableConfigurationImpl.class.getName());
            prop.setProperty("drools.dt.type", DecisionTableInputType.valueOf((String)extension.toUpperCase()).toString());
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        }
        this.resourceConfigurationCache.put(fileName, conf);
        return conf;
    }

    @Override
    public InternalKieModule.CompilationCache getCompilationCache(String kbaseName) {
        byte[] fileContents;
        InternalKieModule.CompilationCache cache = this.compilationCache.get(kbaseName);
        if (cache == null && (fileContents = this.getBytes(KieBuilderImpl.getCompilationCachePath((AFReleaseId)this.releaseId, kbaseName))) != null) {
            ExtensionRegistry registry = KieModuleCacheHelper.buildRegistry();
            try {
                KieModuleCache.Header _header = KieModuleCacheHelper.readFromStreamWithHeaderPreloaded(new ByteArrayInputStream(fileContents), registry);
                if (!Drools.isCompatible((int)_header.getVersion().getVersionMajor(), (int)_header.getVersion().getVersionMinor(), (int)_header.getVersion().getVersionRevision())) {
                    log.warn("The compilation cache has been built with an incompatible version. You should recompile your project in order to use it with current release.");
                    return null;
                }
                KieModuleCache.KModuleCache _cache = KieModuleCache.KModuleCache.parseFrom(_header.getPayload());
                cache = new InternalKieModule.CompilationCache();
                for (KieModuleCache.CompilationData _data : _cache.getCompilationDataList()) {
                    for (KieModuleCache.CompDataEntry _entry : _data.getEntryList()) {
                        cache.addEntry(_data.getDialect(), _entry.getId(), _entry.getData().toByteArray());
                    }
                }
                this.compilationCache.put(kbaseName, cache);
            }
            catch (Exception e) {
                log.error("Unable to load compilation cache... ", (Throwable)e);
            }
        }
        return cache;
    }

    @Override
    public PomModel getPomModel() {
        if (this.pomModel == null) {
            try {
                byte[] pomXml = this.getPomXml();
                if (pomXml != null) {
                    PomModel tempPomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)new ByteArrayInputStream(pomXml));
                    this.validatePomModel(tempPomModel);
                    this.pomModel = tempPomModel;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pomModel;
    }

    public void setPomModel(PomModel pomModel) {
        this.pomModel = pomModel;
    }

    private void validatePomModel(PomModel pomModel) {
        AFReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty((CharSequence)pomReleaseId.getGroupId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    private byte[] getPomXml() {
        return this.getBytes(((ReleaseIdImpl)this.releaseId).getPomXmlPath());
    }

    @Override
    public InputStream getPomAsStream() {
        byte[] pom = this.getBytes(((ReleaseIdImpl)this.releaseId).getPomXmlPath());
        return pom != null ? new ByteArrayInputStream(pom) : null;
    }

    public static boolean updateResource(CompositeKnowledgeBuilder ckbuilder, InternalKieModule kieModule, String resourceName, ResourceChangeSet changes) {
        ResourceConfiguration conf = kieModule.getResourceConfiguration(resourceName);
        Resource resource = kieModule.getResource(resourceName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName), changes);
            } else {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName), conf, changes);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceProvider createResourceProvider() {
        try {
            return new KieModuleResourceProvider(this, this.getFile().toURI().toURL());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class KieModuleResourceProvider
    implements ResourceProvider {
        private final InternalKieModule kieModule;
        private final URL kieModuleUrl;

        private KieModuleResourceProvider(InternalKieModule kieModule, URL kieModuleUrl) {
            this.kieModule = kieModule;
            this.kieModuleUrl = kieModuleUrl;
        }

        public InputStream getResourceAsStream(String name) throws IOException {
            Resource resource;
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return (resource = this.kieModule.getResource(name)) != null ? resource.getInputStream() : null;
        }

        public URL getResource(String name) {
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return this.kieModule.hasResource(name) ? this.createURLForResource(name) : null;
        }

        private URL createURLForResource(String name) {
            try {
                if (this.kieModule instanceof ZipKieModule) {
                    return new URL("jar", "", this.kieModuleUrl + "!/" + name);
                }
                return new URL(this.kieModuleUrl, name);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
}

