/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.server;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.ext.uberfire.social.activities.events.SocialUserFollowedEvent;
import org.ext.uberfire.social.activities.events.SocialUserUnFollowedEvent;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.ext.uberfire.social.activities.service.SocialUserServiceAPI;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class SocialUserService
implements SocialUserServiceAPI {
    @Inject
    private Event<SocialUserFollowedEvent> followedEvent;
    @Inject
    private Event<SocialUserUnFollowedEvent> unFollowedEvent;
    @Inject
    @Named(value="socialUserPersistenceAPI")
    private SocialUserPersistenceAPI socialUserPersistenceAPI;

    public void userFollowAnotherUser(String followerUsername, String followUsername) {
        SocialUser follower = this.socialUserPersistenceAPI.getSocialUser(followerUsername);
        SocialUser follow = this.socialUserPersistenceAPI.getSocialUser(followUsername);
        follower.follow(follow);
        this.socialUserPersistenceAPI.updateUsers(new SocialUser[]{follower, follow});
        this.followedEvent.fire((Object)new SocialUserFollowedEvent(follower, follow));
    }

    public void userUnfollowAnotherUser(String followerUsername, String followUsername) {
        SocialUser follower = this.socialUserPersistenceAPI.getSocialUser(followerUsername);
        SocialUser user = this.socialUserPersistenceAPI.getSocialUser(followUsername);
        follower.unfollow(user);
        this.socialUserPersistenceAPI.updateUsers(new SocialUser[]{follower, user});
        this.unFollowedEvent.fire((Object)new SocialUserUnFollowedEvent(follower, user));
    }

    public void update(SocialUser ... users) {
        this.socialUserPersistenceAPI.updateUsers(users);
    }
}

