/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.assetUsages;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.kie.workbench.common.services.refactoring.service.impact.RefactorOperationBuilder;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class AssetsUsageServiceImpl
implements AssetsUsageService {
    private KieModuleService moduleService;
    private RefactoringQueryService refactoringQueryService;

    @Inject
    public AssetsUsageServiceImpl(KieModuleService moduleService, RefactoringQueryService refactoringQueryService) {
        this.moduleService = moduleService;
        this.refactoringQueryService = refactoringQueryService;
    }

    public List<org.uberfire.backend.vfs.Path> getAssetUsages(String resourceFQN, ResourceType resourceType, org.uberfire.backend.vfs.Path assetPath) {
        return this.getQueryList(assetPath, (RefactorOperationBuilder.RequiresModule)QueryOperationRequest.references((String)resourceFQN, (ResourceType)resourceType));
    }

    public List<org.uberfire.backend.vfs.Path> getAssetPartUsages(String resourceFQN, String resourcePart, PartType partType, org.uberfire.backend.vfs.Path assetPath) {
        return this.getQueryList(assetPath, QueryOperationRequest.referencesPart((String)resourceFQN, (String)resourcePart, (PartType)partType));
    }

    protected List<org.uberfire.backend.vfs.Path> getQueryList(org.uberfire.backend.vfs.Path assetPath, RefactorOperationBuilder.RequiresModule builder) {
        KieModule project = (KieModule)this.moduleService.resolveModule(assetPath);
        String branch = "master";
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)assetPath);
        if (nioPath instanceof SegmentedPath) {
            branch = ((SegmentedPath)nioPath).getSegmentId();
        }
        QueryOperationRequest request = (QueryOperationRequest)builder.inModuleRootPathURI(project.getRootPath().toURI()).onBranch(branch);
        return this.refactoringQueryService.queryToList(request).stream().map(row -> (org.uberfire.backend.vfs.Path)row.getValue()).collect(Collectors.toList());
    }
}

