/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.impact;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.services.refactoring.Resource;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.SharedPart;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceReferenceCollector {
    private static final Logger logger = LoggerFactory.getLogger(ResourceReferenceCollector.class);
    private Map<String, Resource> resourcesMap;
    private Map<String, ResourceReference> referencedResourcesMap;
    private Set<SharedPart> sharedPartReferences;

    public Collection<ResourceReference> getResourceReferences() {
        if (this.referencedResourcesMap != null) {
            return this.referencedResourcesMap.values();
        }
        return Collections.emptyList();
    }

    public Collection<SharedPart> getSharedReferences() {
        if (this.sharedPartReferences != null) {
            return this.sharedPartReferences;
        }
        return Collections.emptyList();
    }

    public Collection<Resource> getResources() {
        if (this.resourcesMap != null) {
            return this.resourcesMap.values();
        }
        return Collections.emptyList();
    }

    private Map<String, ResourceReference> internalGetResourceReferences() {
        if (this.referencedResourcesMap == null) {
            this.referencedResourcesMap = new HashMap<String, ResourceReference>(4);
        }
        return this.referencedResourcesMap;
    }

    public ResourceReference addResourceReference(String fullyQualifiedName, ResourceType type) {
        ResourceReference resRef = this.internalGetResourceReferences().get(fullyQualifiedName);
        if (resRef == null) {
            resRef = new ResourceReference(fullyQualifiedName, type);
            this.referencedResourcesMap.put(fullyQualifiedName, resRef);
        } else if (type != null && !type.equals((Object)resRef.getResourceType())) {
            String msg = "Existing resource reference found with type " + resRef.getResourceType().toString() + " (tried to add resrouce reference of type " + type.toString() + ")";
            logger.error(msg);
        }
        return resRef;
    }

    public void addResourceReferences(ResourceReferenceCollector collector) {
        if (collector.referencedResourcesMap != null) {
            Map<String, ResourceReference> refResMap = this.internalGetResourceReferences();
            for (Map.Entry<String, ResourceReference> resRefEntry : collector.referencedResourcesMap.entrySet()) {
                ResourceReference newResRef = resRefEntry.getValue();
                ResourceReference existingResRef = refResMap.put(resRefEntry.getKey(), newResRef);
                if (existingResRef == null) continue;
                newResRef.addPartReference(existingResRef.getPartReferences());
            }
        }
    }

    public void addSharedReference(String partName, PartType partType) {
        if (this.sharedPartReferences == null) {
            this.sharedPartReferences = new HashSet<SharedPart>();
        }
        this.sharedPartReferences.add(new SharedPart(partName, partType));
    }

    public Resource addResource(String resourceFQN, ResourceType type) {
        Resource resRef;
        if (this.resourcesMap == null) {
            this.resourcesMap = new HashMap<String, Resource>(4);
        }
        if ((resRef = this.resourcesMap.get(resourceFQN)) == null) {
            resRef = new Resource(resourceFQN, type);
            this.resourcesMap.put(resourceFQN, resRef);
        } else if (type != null && !type.equals((Object)resRef.getResourceType())) {
            String msg = "Existing resource found with type " + resRef.getResourceType().toString() + " (tried to add resource reference of type " + type.toString() + ")";
            logger.error(msg);
        }
        return resRef;
    }
}

