/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.persistence;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.persistence.SocialClusterMessage;
import org.ext.uberfire.social.activities.persistence.SocialMessageWrapper;
import org.ext.uberfire.social.activities.persistence.SocialTimelineCacheClusterPersistence;
import org.ext.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.ext.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class SocialClusterMessaging {
    public static final String CHANNEL_NAME = "SOCIAL_CLUSTER_MESSAGE";
    private SocialTimelinePersistenceAPI socialTimelinePersistence;
    @Inject
    private SocialEventTypeRepositoryAPI socialEventTypeRepository;
    private SocialUserPersistenceAPI socialUserPersistenceAPI;
    private ClusterService clusterService;
    private String nodeId = UUID.randomUUID().toString();

    public void setup(ClusterService clusterService, SocialTimelinePersistenceAPI socialTimelinePersistenceAPI, SocialUserPersistenceAPI socialUserPersistenceAPI) {
        this.clusterService = clusterService;
        this.socialTimelinePersistence = socialTimelinePersistenceAPI;
        this.socialUserPersistenceAPI = socialUserPersistenceAPI;
        if (this.clusterService.isAppFormerClustered()) {
            this.clusterService.connect();
            this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, CHANNEL_NAME, SocialMessageWrapper.class, message -> {
                if (!message.getNodeId().equals(this.nodeId)) {
                    SocialClusterMessage messageType = message.getMessageType();
                    if (messageType == SocialClusterMessage.SOCIAL_EVENT) {
                        this.handleSocialEvent((SocialMessageWrapper)message);
                    }
                    if (messageType == SocialClusterMessage.SOCIAL_FILE_SYSTEM_PERSISTENCE) {
                        this.handleSocialPersistenceEvent((SocialMessageWrapper)message);
                    }
                    if (messageType == SocialClusterMessage.CLUSTER_SHUTDOWN) {
                        this.handleClusterShutdown();
                    }
                }
            });
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.clusterService.isAppFormerClustered()) {
            this.clusterService.close();
        }
    }

    private void handleClusterShutdown() {
        SocialTimelineCacheClusterPersistence cacheClusterPersistence = (SocialTimelineCacheClusterPersistence)this.socialTimelinePersistence;
        cacheClusterPersistence.someNodeShutdownAndPersistEvents();
    }

    private void handleSocialPersistenceEvent(SocialMessageWrapper message) {
        SocialUser user;
        SocialActivitiesEvent eventTypeName;
        SocialTimelineCacheClusterPersistence cacheClusterPersistence = (SocialTimelineCacheClusterPersistence)this.socialTimelinePersistence;
        if (message.getSubMessageType().equals((Object)SocialClusterMessage.UPDATE_TYPE_EVENT) && (eventTypeName = message.getEvent()) != null) {
            SocialEventType typeEvent = this.socialEventTypeRepository.findType(eventTypeName.getType());
            cacheClusterPersistence.persist(SocialActivitiesEvent.getDummyLastWrittenMarker(), typeEvent, false);
        }
        if (message.getSubMessageType().equals((Object)SocialClusterMessage.UPDATE_USER_EVENT) && (user = message.getUser()) != null) {
            cacheClusterPersistence.persist(user, SocialActivitiesEvent.getDummyLastWrittenMarker());
        }
    }

    private void handleSocialEvent(SocialMessageWrapper message) {
        SocialActivitiesEvent event = message.getEvent();
        SocialUser user = message.getUser();
        if (event != null) {
            SocialEventType typeEvent = this.socialEventTypeRepository.findType(event.getType());
            SocialTimelineCacheClusterPersistence cacheClusterPersistence = (SocialTimelineCacheClusterPersistence)this.socialTimelinePersistence;
            cacheClusterPersistence.persist(event, typeEvent, false);
            if (user != null) {
                cacheClusterPersistence.persist(user, event);
                for (String followerName : user.getFollowersName()) {
                    SocialUser follower = this.socialUserPersistenceAPI.getSocialUser(followerName);
                    cacheClusterPersistence.persist(follower, event);
                }
            }
        }
    }

    public void notify(SocialActivitiesEvent event) {
        if (!this.clusterService.isAppFormerClustered()) {
            return;
        }
        this.clusterService.broadcast(ClusterService.DestinationType.PubSub, CHANNEL_NAME, (Serializable)new SocialMessageWrapper(this.nodeId, SocialClusterMessage.SOCIAL_EVENT, event, event.getSocialUser()));
    }

    public void notifyTimeLineUpdate(SocialActivitiesEvent event) {
        if (!this.clusterService.isAppFormerClustered()) {
            return;
        }
        this.clusterService.broadcast(ClusterService.DestinationType.PubSub, CHANNEL_NAME, (Serializable)new SocialMessageWrapper(this.nodeId, SocialClusterMessage.SOCIAL_FILE_SYSTEM_PERSISTENCE, event, null, SocialClusterMessage.UPDATE_TYPE_EVENT));
    }

    public void notifyTimeLineUpdate(SocialUser user, List<SocialActivitiesEvent> storedEvents) {
        if (!this.clusterService.isAppFormerClustered()) {
            return;
        }
        this.clusterService.broadcast(ClusterService.DestinationType.PubSub, CHANNEL_NAME, (Serializable)new SocialMessageWrapper(this.nodeId, SocialClusterMessage.SOCIAL_FILE_SYSTEM_PERSISTENCE, null, user, SocialClusterMessage.UPDATE_USER_EVENT));
    }

    public void notifySomeInstanceIsOnShutdown() {
        if (!this.clusterService.isAppFormerClustered()) {
            return;
        }
        this.clusterService.broadcast(ClusterService.DestinationType.PubSub, CHANNEL_NAME, (Serializable)new SocialMessageWrapper(this.nodeId, SocialClusterMessage.CLUSTER_SHUTDOWN));
    }
}

