/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.commons.lifecycle.Disposable;
import org.uberfire.ext.metadata.backend.infinispan.exceptions.InfinispanException;
import org.uberfire.ext.metadata.backend.infinispan.proto.KObjectMarshaller;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Schema;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.SchemaGenerator;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanConfiguration;
import org.uberfire.ext.metadata.backend.infinispan.provider.KieProtostreamMarshaller;
import org.uberfire.ext.metadata.backend.infinispan.provider.LoginHandler;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.model.KObject;

public class InfinispanContext
implements Disposable {
    private static final String PORT = "org.appformer.ext.metadata.infinispan.port";
    private static final String HOST = "org.appformer.ext.metadata.infinispan.host";
    private static final String USERNAME = "org.appformer.ext.metadata.infinispan.username";
    private static final String PASSWORD = "org.appformer.ext.metadata.infinispan.password";
    private static final String REALM = "org.appformer.ext.metadata.infinispan.realm";
    private static final String TYPES_CACHE = "types";
    private static final String SCHEMAS_CACHE = "schemas";
    private static final String PROTO_EXTENSION = ".proto";
    private static final String SCHEMA_PROTO = "schema.proto";
    private static final String ORG_KIE = "org.kie.";
    public static final String SASL_MECHANISM = "DIGEST-MD5";
    private final RemoteCacheManager cacheManager;
    private final KieProtostreamMarshaller marshaller = new KieProtostreamMarshaller();
    private final SchemaGenerator schemaGenerator;
    private final InfinispanConfiguration infinispanConfiguration = new InfinispanConfiguration();

    public static InfinispanContext getInstance() {
        return LazyHolder.INSTANCE;
    }

    private InfinispanContext(Map<String, String> properties) {
        this.schemaGenerator = new SchemaGenerator();
        this.cacheManager = this.createRemoteCache(properties);
        if (!this.getIndices().contains(TYPES_CACHE)) {
            this.cacheManager.administration().createCache(TYPES_CACHE, (BasicConfiguration)this.infinispanConfiguration.getConfiguration(TYPES_CACHE));
        }
        if (!this.getIndices().contains(SCHEMAS_CACHE)) {
            this.cacheManager.administration().createCache(SCHEMAS_CACHE, (BasicConfiguration)this.infinispanConfiguration.getConfiguration(SCHEMAS_CACHE));
        }
        this.marshaller.registerMarshaller(new KieProtostreamMarshaller.KieMarshallerSupplier<KObject>(){

            @Override
            public String extractTypeFromEntity(KObject entity) {
                return InfinispanContext.ORG_KIE + AttributesUtil.toProtobufFormat(entity.getClusterId() + "_" + entity.getType().getName());
            }

            @Override
            public Class<KObject> getJavaClass() {
                return KObject.class;
            }

            @Override
            public BaseMarshaller<KObject> getMarshallerForType(String typeName) {
                return new KObjectMarshaller(typeName);
            }
        });
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.cacheManager);
        this.addProtobufClass(serializationContext, SCHEMA_PROTO, Schema.class);
        this.loadProtobufSchema(this.getProtobufCache());
    }

    private RemoteCacheManager createRemoteCache(Map<String, String> properties) {
        String username = properties.get(USERNAME);
        String password = properties.get(PASSWORD);
        String realm = properties.get(REALM);
        String host = properties.get(HOST);
        String port = properties.get(PORT);
        try {
            ConfigurationBuilder builder = this.getMaybeSecurityBuilder(username, password, realm).addServer().host(host).port(Integer.parseInt(port)).marshaller((Marshaller)new ProtoStreamMarshaller()).marshaller((Marshaller)this.marshaller);
            return new RemoteCacheManager(builder.build());
        }
        catch (Exception e) {
            throw new InfinispanException(MessageFormat.format("Error trying to connect to server <{0}:{1}>", host, port), e);
        }
    }

    private AuthenticationConfigurationBuilder getMaybeSecurityBuilder(String username, String password, String realm) {
        ConfigurationBuilder b = new ConfigurationBuilder();
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            PortablePreconditions.checkNotEmpty((String)"password", (String)password);
            PortablePreconditions.checkNotEmpty((String)"realm", (String)realm);
            return b.security().authentication().enable().saslMechanism(SASL_MECHANISM).callbackHandler((CallbackHandler)new LoginHandler(username, password.toCharArray(), realm));
        }
        return b.security().authentication().disable();
    }

    private void addProtobufClass(SerializationContext serializationContext, String protoName, Class<?> clazz) {
        try {
            ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
            protoSchemaBuilder.fileName(protoName);
            protoSchemaBuilder.addClass(clazz);
            String schemaString = protoSchemaBuilder.build(serializationContext);
            this.getProtobufCache().put((Object)protoName, (Object)schemaString);
        }
        catch (IOException e) {
            throw new InfinispanException("Can't add protobuf class <" + protoName + "> to cache", e);
        }
    }

    private RemoteCache<String, String> getProtobufCache() {
        return this.cacheManager.getCache("___protobuf_metadata");
    }

    public RemoteCache<String, KObject> getCache(String index) {
        String i = AttributesUtil.toProtobufFormat(index).toLowerCase();
        if (!this.getIndices().contains(i)) {
            this.cacheManager.administration().createCache(i, (BasicConfiguration)this.infinispanConfiguration.getIndexedConfiguration(i));
        }
        return this.cacheManager.getCache(i);
    }

    public List<String> getTypes(String index) {
        return this.getSchema(index).map(schema -> schema.getMessages().stream().map(x -> x.getName()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public void addProtobufSchema(String clusterId, Schema schema) {
        try {
            String protoTypeName = AttributesUtil.toProtobufFormat(clusterId);
            RemoteCache<String, String> metadataCache = this.getProtobufCache();
            String proto = this.schemaGenerator.generate(schema);
            this.marshaller.registerSchema(protoTypeName, proto, KObject.class);
            metadataCache.put((Object)(protoTypeName + PROTO_EXTENSION), (Object)proto);
        }
        catch (IOException e) {
            throw new InfinispanException("Can't add protobuf schema <" + schema.getName() + "> to cache", e);
        }
    }

    public void loadProtobufSchema(RemoteCache<String, String> metadataCache) {
        metadataCache.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(SCHEMA_PROTO)).forEach(entry -> {
            int index = ((String)entry.getKey()).lastIndexOf(46);
            String protoTypeName = ((String)entry.getKey()).substring(0, index);
            String proto = (String)entry.getValue();
            try {
                this.marshaller.registerSchema(protoTypeName, proto, KObject.class);
            }
            catch (IOException e) {
                throw new InfinispanException("Can't add protobuf schema <" + protoTypeName + "> to cache", e);
            }
        });
    }

    public void dispose() {
        if (this.cacheManager.isStarted()) {
            this.cacheManager.stop();
        }
    }

    public List<String> getIndices() {
        return new ArrayList<String>(this.cacheManager.getCacheNames());
    }

    public Optional<Schema> getSchema(String clusterId) {
        Schema schema = (Schema)this.cacheManager.getCache(SCHEMAS_CACHE).get((Object)clusterId.toLowerCase());
        return Optional.ofNullable(schema);
    }

    public void addSchema(Schema schema) {
        this.cacheManager.getCache(SCHEMAS_CACHE).put((Object)AttributesUtil.toProtobufFormat(schema.getName()).toLowerCase(), (Object)schema);
    }

    private static final class LazyHolder {
        static final Map<String, String> PROPERTIES = new HashMap<String, String>(){
            {
                this.put(InfinispanContext.HOST, System.getProperty(InfinispanContext.HOST, "127.0.0.1"));
                this.put(InfinispanContext.PORT, System.getProperty(InfinispanContext.PORT, "11222"));
                this.put(InfinispanContext.USERNAME, System.getProperty(InfinispanContext.USERNAME, ""));
                this.put(InfinispanContext.PASSWORD, System.getProperty(InfinispanContext.PASSWORD, ""));
                this.put(InfinispanContext.REALM, System.getProperty(InfinispanContext.REALM, "ApplicationRealm"));
            }
        };
        static final InfinispanContext INSTANCE = new InfinispanContext(PROPERTIES);

        private LazyHolder() {
        }
    }
}

