/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.expression;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.expr.BigDecimalLiteralExpr;
import org.drools.javaparser.ast.expr.BigIntegerLiteralExpr;
import org.drools.javaparser.ast.expr.CastExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NullLiteralExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.PrimitiveType;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.IndexIdGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.MultipleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.SingleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expression.FlowExpressionBuilder;
import org.drools.modelcompiler.builder.generator.expression.PatternExpressionBuilder;
import org.drools.modelcompiler.util.ClassUtil;

public abstract class AbstractExpressionBuilder {
    protected static final IndexIdGenerator indexIdGenerator = new IndexIdGenerator();
    protected RuleContext context;

    protected AbstractExpressionBuilder(RuleContext context) {
        this.context = context;
    }

    public void processExpression(DrlxParseSuccess drlxParseResult) {
        if (drlxParseResult instanceof SingleDrlxParseSuccess) {
            this.processExpression((SingleDrlxParseSuccess)drlxParseResult);
        } else if (drlxParseResult instanceof MultipleDrlxParseSuccess) {
            this.processExpression((MultipleDrlxParseSuccess)drlxParseResult);
        } else {
            throw new UnsupportedOperationException("Unknown expression type: " + drlxParseResult.getClass().getName());
        }
    }

    public void processExpression(SingleDrlxParseSuccess drlxParseResult) {
        Expression dslExpr;
        if (drlxParseResult.hasUnificationVariable()) {
            dslExpr = this.buildUnificationExpression(drlxParseResult);
            this.context.addExpression(dslExpr);
        } else if (drlxParseResult.isValidExpression()) {
            dslExpr = this.buildExpressionWithIndexing(drlxParseResult);
            this.context.addExpression(dslExpr);
        }
        if (drlxParseResult.getExprBinding() != null) {
            dslExpr = this.buildBinding(drlxParseResult);
            this.context.addExpression(dslExpr);
        }
    }

    public void processExpression(MultipleDrlxParseSuccess drlxParseResult) {
        if (drlxParseResult.isValidExpression()) {
            MethodCallExpr dslExpr = this.buildExpressionWithIndexing(drlxParseResult);
            this.context.addExpression((Expression)dslExpr);
        }
    }

    private Expression buildUnificationExpression(SingleDrlxParseSuccess drlxParseResult) {
        MethodCallExpr exprDSL = this.buildBinding(drlxParseResult);
        this.context.addDeclaration(drlxParseResult.getUnificationVariable(), drlxParseResult.getUnificationVariableType(), drlxParseResult.getUnificationName());
        return exprDSL;
    }

    public abstract MethodCallExpr buildExpressionWithIndexing(DrlxParseSuccess var1);

    public abstract MethodCallExpr buildBinding(SingleDrlxParseSuccess var1);

    protected Expression getConstraintExpression(SingleDrlxParseSuccess drlxParseResult) {
        if (drlxParseResult.getExpr() instanceof EnclosedExpr) {
            return this.buildConstraintExpression(drlxParseResult, ((EnclosedExpr)drlxParseResult.getExpr()).getInner());
        }
        TypedExpression left = drlxParseResult.getLeft();
        Expression e = left != null ? DrlxParseUtil.findLeftLeafOfMethodCall(left.getExpression()) : drlxParseResult.getExpr();
        return this.buildConstraintExpression(drlxParseResult, drlxParseResult.getUsedDeclarationsOnLeft(), e);
    }

    protected Expression buildConstraintExpression(SingleDrlxParseSuccess drlxParseResult, Expression expr) {
        return this.buildConstraintExpression(drlxParseResult, drlxParseResult.getUsedDeclarations(), expr);
    }

    protected Expression buildConstraintExpression(SingleDrlxParseSuccess drlxParseResult, Collection<String> usedDeclarations, Expression expr) {
        return drlxParseResult.isStatic() ? expr : DrlxParseUtil.generateLambdaWithoutParameters(usedDeclarations, expr, drlxParseResult.isSkipThisAsParam());
    }

    boolean hasIndex(SingleDrlxParseSuccess drlxParseResult) {
        TypedExpression left = drlxParseResult.getLeft();
        Collection<String> usedDeclarations = drlxParseResult.getUsedDeclarations();
        return drlxParseResult.getDecodeConstraintType() != null && left.getFieldName() != null && !this.isThisExpression(left.getExpression()) && (this.isAlphaIndex(usedDeclarations) || this.isBetaIndex(usedDeclarations, drlxParseResult.getRight()));
    }

    boolean isAlphaIndex(Collection<String> usedDeclarations) {
        return usedDeclarations.isEmpty();
    }

    private boolean isBetaIndex(Collection<String> usedDeclarations, TypedExpression right) {
        return usedDeclarations.size() == 1 && this.context.getDeclarationById(AbstractExpressionBuilder.getExpressionSymbolForBetaIndex(right.getExpression())).isPresent();
    }

    private static String getExpressionSymbolForBetaIndex(Expression expr) {
        Expression scope = expr instanceof MethodCallExpr && ((MethodCallExpr)expr).getScope().isPresent() ? (Expression)((MethodCallExpr)expr).getScope().get() : (expr instanceof FieldAccessExpr ? ((FieldAccessExpr)expr).getScope() : expr);
        return scope instanceof NameExpr ? ((NameExpr)scope).getNameAsString() : null;
    }

    private boolean isThisExpression(Expression leftExpr) {
        return leftExpr instanceof NameExpr && ((NameExpr)leftExpr).getName().getIdentifier().equals("_this");
    }

    public static AbstractExpressionBuilder getExpressionBuilder(RuleContext context) {
        return context.isPatternDSL() ? new PatternExpressionBuilder(context) : new FlowExpressionBuilder(context);
    }

    protected Expression narrowExpressionToType(TypedExpression right, Type leftType) {
        Object expression = right.getExpression();
        if (expression instanceof NullLiteralExpr) {
            return expression;
        }
        if (leftType.equals(Double.class)) {
            expression = new CastExpr((org.drools.javaparser.ast.type.Type)PrimitiveType.doubleType(), expression);
        } else if (leftType.equals(Long.class)) {
            expression = right.getType().equals(Double.class) || right.getType().equals(Double.TYPE) ? new MethodCallExpr(expression, "longValue") : new CastExpr((org.drools.javaparser.ast.type.Type)PrimitiveType.longType(), expression);
        } else if (expression instanceof LiteralExpr) {
            if (expression instanceof BigDecimalLiteralExpr) {
                expression = AbstractExpressionBuilder.toNewExpr(BigDecimal.class, (Expression)new StringLiteralExpr(((BigDecimalLiteralExpr)expression).asBigDecimal().toString()));
            } else if (expression instanceof BigIntegerLiteralExpr) {
                expression = AbstractExpressionBuilder.toNewExpr(ClassUtil.toRawClass(leftType), (Expression)new StringLiteralExpr(((BigIntegerLiteralExpr)expression).asBigInteger().toString()));
            } else if (leftType.equals(BigDecimal.class)) {
                BigDecimal bigDecimal = new BigDecimal(expression.toString());
                expression = AbstractExpressionBuilder.toNewExpr(BigDecimal.class, (Expression)new StringLiteralExpr(bigDecimal.toString()));
            } else if (leftType.equals(BigInteger.class)) {
                BigInteger bigInteger = new BigDecimal(expression.toString()).toBigInteger();
                expression = AbstractExpressionBuilder.toNewExpr(BigInteger.class, (Expression)new StringLiteralExpr(bigInteger.toString()));
            }
        } else if (expression instanceof NameExpr) {
            if (leftType.equals(BigDecimal.class)) {
                expression = AbstractExpressionBuilder.toNewExpr(BigDecimal.class, expression);
            } else if (leftType.equals(BigInteger.class)) {
                expression = AbstractExpressionBuilder.toNewExpr(BigInteger.class, expression);
            }
        }
        return expression;
    }

    private static Expression toNewExpr(Class<?> clazz, Expression initExpression) {
        return new ObjectCreationExpr(null, DrlxParseUtil.toClassOrInterfaceType(clazz), NodeList.nodeList((Node[])new Expression[]{initExpression}));
    }

    protected void addIndexedByDeclaration(TypedExpression left, TypedExpression right, boolean leftContainsThis, MethodCallExpr indexedByDSL, Collection<String> usedDeclarations, Type leftType) {
        LambdaExpr indexedBy_rightOperandExtractor = new LambdaExpr();
        indexedBy_rightOperandExtractor.addParameter(new Parameter((org.drools.javaparser.ast.type.Type)new UnknownType(), usedDeclarations.iterator().next()));
        TypedExpression expression = !leftContainsThis ? left : right;
        Expression narrowed = this.narrowExpressionToType(expression, leftType);
        indexedBy_rightOperandExtractor.setBody((Statement)new ExpressionStmt(narrowed));
        indexedByDSL.addArgument((Expression)indexedBy_rightOperandExtractor);
    }

    protected Class<?> getIndexType(TypedExpression left, TypedExpression right) {
        return Stream.of(left, right).map(TypedExpression::getType).filter(Objects::nonNull).map(ClassUtil::toRawClass).findFirst().get();
    }
}

