/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.pom;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.guvnor.structure.backend.pom.PomJsonReader;
import org.guvnor.structure.pom.DependencyType;
import org.guvnor.structure.pom.DynamicPomDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

public class PomJsonReaderDefault
implements PomJsonReader {
    private final Logger logger = LoggerFactory.getLogger(PomJsonReaderDefault.class);
    private JsonObject pomObject;

    public PomJsonReaderDefault(InputStream in) {
        try (JsonReader reader = Json.createReader((InputStream)in);){
            this.pomObject = reader.readObject();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public PomJsonReaderDefault(String path, String jsonName) {
        String jsonPath = path + jsonName;
        if (!Files.exists((Path)Paths.get((String)jsonPath, (String[])new String[0]), (LinkOption[])new LinkOption[0])) {
            throw new RuntimeException("no " + jsonName + " in the provided path :" + path);
        }
        try (FileInputStream fis = new FileInputStream(jsonPath);
             JsonReader reader = Json.createReader((InputStream)fis);){
            this.pomObject = reader.readObject();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Map<DependencyType, List<DynamicPomDependency>> readDeps() {
        JsonArray dependencies = this.pomObject.getJsonArray("dependencies");
        HashMap<DependencyType, List<DynamicPomDependency>> mapping = new HashMap<DependencyType, List<DynamicPomDependency>>(dependencies.size());
        for (int i = 0; i < dependencies.size(); ++i) {
            JsonObject depType = dependencies.getJsonObject(i);
            String type = depType.getString("type");
            JsonArray deps = depType.getJsonArray("deps");
            ArrayList<DynamicPomDependency> dynamic = new ArrayList<DynamicPomDependency>(deps.size());
            for (int k = 0; k < deps.size(); ++k) {
                JsonObject dep = deps.getJsonObject(i);
                DynamicPomDependency dynamicDep = new DynamicPomDependency(dep.getString("groupId"), dep.getString("artifactId"), dep.getString("version"), dep.getString("scope"));
                dynamic.add(dynamicDep);
            }
            mapping.put(DependencyType.valueOf((String)type), dynamic);
        }
        return mapping;
    }
}

