/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.fields.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.errai.common.client.api.Assert;
import org.kie.workbench.common.forms.fields.shared.FieldProvider;
import org.kie.workbench.common.forms.fields.shared.MultipleValueFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.BasicTypeFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.HasPlaceHolder;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.EntityRelationField;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.multipleSubform.definition.MultipleSubFormFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.subForm.definition.SubFormFieldDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FieldType;
import org.kie.workbench.common.forms.model.MetaDataEntry;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.meta.entries.FieldTypeEntry;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldManager
implements FieldManager {
    private static transient Logger log = LoggerFactory.getLogger(FieldManager.class);
    protected Set<BasicTypeFieldProvider> basicProviders = new TreeSet<BasicTypeFieldProvider>((o1, o2) -> o1.getPriority() - o2.getPriority());
    protected Set<BasicTypeFieldProvider> basicMultipleProviders = new TreeSet<BasicTypeFieldProvider>((o1, o2) -> o1.getPriority() - o2.getPriority());
    protected Map<String, FieldProvider> entityTypeFieldProvider = new HashMap<String, FieldProvider>();
    protected Map<String, FieldProvider> multipleEntityTypeFieldProvider = new HashMap<String, FieldProvider>();
    protected Map<String, FieldProvider> providersByFieldCode = new HashMap<String, FieldProvider>();
    protected Map<Class<? extends FieldType>, FieldProvider> providerByFieldType = new HashMap<Class<? extends FieldType>, FieldProvider>();
    protected String defaultSingleEntity = SubFormFieldDefinition.FIELD_TYPE.getTypeName();
    protected String defaultMultipleEntity = MultipleSubFormFieldDefinition.FIELD_TYPE.getTypeName();
    private MetaDataEntryManager metaDataEntryManager;

    public AbstractFieldManager(MetaDataEntryManager metaDataEntryManager) {
        this.metaDataEntryManager = metaDataEntryManager;
    }

    protected void registerFieldProvider(FieldProvider provider) {
        boolean isMultiple = provider instanceof MultipleValueFieldProvider;
        if (provider instanceof BasicTypeFieldProvider) {
            BasicTypeFieldProvider basicTypeProvider = (BasicTypeFieldProvider)provider;
            if (isMultiple) {
                this.basicMultipleProviders.add(basicTypeProvider);
            } else {
                this.basicProviders.add(basicTypeProvider);
            }
        } else if (isMultiple) {
            this.multipleEntityTypeFieldProvider.put(provider.getFieldTypeName(), provider);
        } else {
            this.entityTypeFieldProvider.put(provider.getFieldTypeName(), provider);
        }
        this.providersByFieldCode.put(provider.getFieldTypeName(), provider);
        this.providerByFieldType.put(provider.getFieldType(), provider);
    }

    public Collection<String> getBaseFieldTypes() {
        ArrayList<String> fieldCodes = new ArrayList<String>();
        for (BasicTypeFieldProvider provider : this.basicProviders) {
            fieldCodes.add(provider.getFieldTypeName());
        }
        fieldCodes.addAll(this.entityTypeFieldProvider.keySet());
        fieldCodes.addAll(this.multipleEntityTypeFieldProvider.keySet());
        return fieldCodes;
    }

    public FieldDefinition getDefinitionByFieldType(FieldType fieldType) {
        return this.getDefinitionByFieldTypeName(fieldType.getTypeName());
    }

    public FieldDefinition getDefinitionByFieldTypeName(String fieldTypeCode) {
        FieldProvider provider = this.providersByFieldCode.get(fieldTypeCode);
        if (provider != null) {
            return provider.getDefaultField();
        }
        return null;
    }

    public FieldDefinition getDefinitionByDataType(TypeInfo typeInfo) {
        if (!TypeKind.OBJECT.equals((Object)typeInfo.getType())) {
            return this.getFieldDefinitionFromBasicProvider(typeInfo);
        }
        FieldProvider provider = typeInfo.isMultiple() ? this.multipleEntityTypeFieldProvider.get(this.defaultMultipleEntity) : this.entityTypeFieldProvider.get(this.defaultSingleEntity);
        if (provider != null) {
            Object instance = provider.getFieldByType(typeInfo);
            instance.setStandaloneClassName(typeInfo.getClassName());
            return instance;
        }
        return null;
    }

    protected FieldDefinition getFieldDefinitionFromBasicProvider(TypeInfo typeInfo) {
        Predicate<BasicTypeFieldProvider> filterPredicate = provider -> provider.isSupported(typeInfo);
        Function<BasicTypeFieldProvider, FieldDefinition> mapFunction = provider -> {
            Object field = provider.getFieldByType(typeInfo);
            field.setStandaloneClassName(typeInfo.getClassName());
            return field;
        };
        if (typeInfo.isMultiple()) {
            return this.basicMultipleProviders.stream().filter(filterPredicate).findFirst().map(mapFunction).orElse(null);
        }
        return this.basicProviders.stream().filter(filterPredicate).findFirst().map(mapFunction).orElse(null);
    }

    public FieldDefinition getDefinitionByModelProperty(ModelProperty modelProperty) {
        Optional<FieldDefinition> optional;
        FieldTypeEntry fieldTypeEntry = (FieldTypeEntry)modelProperty.getMetaData().getEntry("field-type");
        FieldDefinition fieldDefinition = null;
        if (fieldTypeEntry != null) {
            fieldDefinition = this.getFieldFromProvider((String)fieldTypeEntry.getValue(), modelProperty.getTypeInfo());
        }
        if (fieldDefinition == null && (optional = Optional.ofNullable(this.getDefinitionByDataType(modelProperty.getTypeInfo()))).isPresent()) {
            fieldDefinition = optional.get();
        }
        if (fieldDefinition != null) {
            fieldDefinition.setName(modelProperty.getName());
            fieldDefinition.setBinding(modelProperty.getName());
            String label = modelProperty.getName();
            label = label.substring(0, 1).toUpperCase() + label.substring(1);
            fieldDefinition.setLabel(label);
            fieldDefinition.setStandaloneClassName(modelProperty.getTypeInfo().getClassName());
            if (fieldDefinition instanceof HasPlaceHolder) {
                ((HasPlaceHolder)fieldDefinition).setPlaceHolder(label);
            }
            for (MetaDataEntry entry : modelProperty.getMetaData().getEntries()) {
                MetaDataEntryProcessor processor = this.metaDataEntryManager.getProcessorForEntry(entry);
                if (processor == null || !processor.supports(fieldDefinition)) continue;
                processor.process(entry, (Object)fieldDefinition);
            }
            return fieldDefinition;
        }
        return null;
    }

    public Collection<String> getCompatibleFields(FieldDefinition fieldDefinition) {
        if (fieldDefinition.getStandaloneClassName() != null) {
            if (fieldDefinition instanceof EntityRelationField) {
                if (fieldDefinition.getFieldTypeInfo().isMultiple()) {
                    return new TreeSet<String>(this.multipleEntityTypeFieldProvider.keySet());
                }
                return new TreeSet<String>(this.entityTypeFieldProvider.keySet());
            }
            TreeSet<String> result = new TreeSet<String>();
            if (fieldDefinition.getFieldTypeInfo().isMultiple()) {
                for (BasicTypeFieldProvider provider : this.basicMultipleProviders) {
                    if (!provider.isCompatible(fieldDefinition)) continue;
                    result.add(provider.getFieldTypeName());
                }
            } else {
                for (BasicTypeFieldProvider provider : this.basicProviders) {
                    if (!provider.isCompatible(fieldDefinition)) continue;
                    result.add(provider.getFieldTypeName());
                }
            }
            return result;
        }
        if (fieldDefinition instanceof EntityRelationField) {
            if (fieldDefinition.getFieldTypeInfo().isMultiple()) {
                return new TreeSet<String>(this.multipleEntityTypeFieldProvider.keySet());
            }
            return new TreeSet<String>(this.entityTypeFieldProvider.keySet());
        }
        BasicTypeFieldProvider provider = (BasicTypeFieldProvider)this.providersByFieldCode.get(fieldDefinition.getFieldType().getTypeName());
        TreeSet<String> result = new TreeSet<String>();
        for (String className : provider.getSupportedTypes()) {
            result.addAll(this.getCompatibleTypes(className));
        }
        return result;
    }

    public Collection<String> getCompatibleTypes(FieldDefinition fieldDefinition) {
        FieldProvider provider = this.providersByFieldCode.get(fieldDefinition.getFieldType().getTypeName());
        if (provider == null) {
            throw new IllegalArgumentException("Unexpected field type '" + fieldDefinition.getFieldType().getTypeName() + "'");
        }
        if (provider instanceof BasicTypeFieldProvider) {
            return Arrays.asList(((BasicTypeFieldProvider)provider).getSupportedTypes());
        }
        return Arrays.asList(fieldDefinition.getStandaloneClassName());
    }

    public FieldDefinition getFieldFromProvider(String typeCode, TypeInfo typeInfo) {
        Assert.notNull((String)"TypeInfo cannot be null", (Object)typeInfo);
        if (typeCode == null) {
            return this.getDefinitionByDataType(typeInfo);
        }
        for (BasicTypeFieldProvider basicProvider : this.basicProviders) {
            if (!basicProvider.getFieldTypeName().equals(typeCode)) continue;
            return basicProvider.getFieldByType(typeInfo);
        }
        for (BasicTypeFieldProvider basicProvider : this.basicMultipleProviders) {
            if (!basicProvider.getFieldTypeName().equals(typeCode)) continue;
            return basicProvider.getFieldByType(typeInfo);
        }
        FieldProvider provider = this.entityTypeFieldProvider.get(typeCode);
        if (provider == null) {
            provider = this.multipleEntityTypeFieldProvider.get(typeCode);
        }
        if (provider != null) {
            return provider.getFieldByType(typeInfo);
        }
        return null;
    }

    public FieldDefinition getDefinitionByFieldType(Class<? extends FieldType> fieldType, TypeInfo typeInfo) {
        FieldProvider provider = this.providerByFieldType.get(fieldType);
        if (provider != null) {
            Object field = provider.getFieldByType(typeInfo);
            if (field != null) {
                field.setStandaloneClassName(typeInfo.getClassName());
            }
            return field;
        }
        return null;
    }

    protected List<String> getCompatibleTypes(String className) {
        ArrayList<String> result = new ArrayList<String>();
        for (BasicTypeFieldProvider provider : this.basicProviders) {
            if (!Arrays.asList(provider.getSupportedTypes()).contains(className)) continue;
            result.add(provider.getFieldTypeName());
        }
        return result;
    }
}

