/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.GetConstructorAction;
import org.jboss.weld.security.SetAccessibleAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static void ensureAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(SetAccessibleAction.of(accessibleObject));
            } else {
                accessibleObject.setAccessible(true);
            }
        }
    }

    static <T> Constructor<T> getConstructor(Class<T> javaClass, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return (Constructor)AccessController.doPrivileged(GetConstructorAction.of(javaClass, parameterTypes));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getConstructor(parameterTypes);
    }
}

