/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.ht;

import java.util.Set;
import java.util.TreeSet;
import org.jbpm.simulation.impl.ht.AllocatedWork;
import org.jbpm.simulation.impl.ht.Range;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class RangeChain {
    private Set<Range> availableRanges = new TreeSet<Range>();

    public void addRange(Range range) {
        this.availableRanges.add(range);
    }

    public long allocateWork(long startTime, long duration) {
        AllocatedWork allocatedWork = new AllocatedWork(duration);
        Interval previousRange = null;
        for (Range range : this.availableRanges) {
            if (range.contains(startTime)) {
                allocatedWork.merge(range.allocate(startTime, duration));
                if (allocatedWork.isAllocated()) break;
                previousRange = range.getInterval();
                continue;
            }
            if (allocatedWork.isAllocated()) continue;
            long gap = 0L;
            if (previousRange != null) {
                gap = previousRange.gap((ReadableInterval)range.getInterval()).toDurationMillis();
                allocatedWork.setWaitTime(allocatedWork.getWaitTime() + gap);
            }
            allocatedWork.merge(range.allocate(range.getInterval().getStartMillis(), duration - allocatedWork.getAllocatedTime()));
        }
        return allocatedWork.getWaitTime();
    }
}

