/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathSupport;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class SavePopUpPresenter {
    private ParameterizedCommand<String> command;
    private View view;
    private Event<SaveInProgressEvent> saveInProgressEvent;
    private ToggleCommentPresenter toggleCommentPresenter;

    @Inject
    public SavePopUpPresenter(View view, Event<SaveInProgressEvent> saveInProgressEvent, ToggleCommentPresenter toggleCommentPresenter) {
        this.toggleCommentPresenter = toggleCommentPresenter;
        this.saveInProgressEvent = saveInProgressEvent;
        this.view = view;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(ParameterizedCommand<String> command) {
        this.command = command;
        this.view.show();
    }

    public void show(Path path, ParameterizedCommand<String> command) {
        ParameterizedCommand<String> wrappedCommand = this.wrapWithSaveInProgressEvent(path, command);
        if (PathSupport.isVersioned((Path)path)) {
            this.show(wrappedCommand);
        } else {
            wrappedCommand.execute((Object)"");
        }
    }

    public ParameterizedCommand<String> getCommand() {
        return this.command;
    }

    public void save() {
        PortablePreconditions.checkNotNull((String)"command", this.command);
        this.command.execute((Object)this.toggleCommentPresenter.getComment());
        this.view.hide();
    }

    public void cancel() {
        this.view.hide();
    }

    private ParameterizedCommand<String> wrapWithSaveInProgressEvent(Path path, ParameterizedCommand<String> command) {
        return parameter -> {
            command.execute(parameter);
            this.saveInProgressEvent.fire((Object)new SaveInProgressEvent(path));
        };
    }

    public ToggleCommentPresenter getToggleCommentPresenter() {
        return this.toggleCommentPresenter;
    }

    public static interface View
    extends UberElement<SavePopUpPresenter> {
        public void show();

        public void hide();
    }
}

