/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.HasLockSyncMenuStateHelper;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.RestoreVersionCommandProvider;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class BasicFileMenuBuilderImpl
implements BasicFileMenuBuilder {
    private RestoreVersionCommandProvider restoreVersionCommandProvider;
    private Event<NotificationEvent> notification;
    private BusyIndicatorView busyIndicatorView;
    private DeletePopUpPresenter deletePopUpPresenter;
    private CopyPopUpPresenter copyPopUpPresenter;
    private RenamePopUpPresenter renamePopUpPresenter;
    private Command saveCommand = null;
    private MenuItem saveMenuItem;
    private Command deleteCommand = null;
    private MenuItem deleteMenuItem;
    private Command renameCommand = null;
    private MenuItem renameMenuItem;
    private Command copyCommand = null;
    private Command validateCommand = null;
    private Command restoreCommand = null;
    private MenuItem restoreMenuItem;
    private List<Pair<String, Command>> otherCommands = new ArrayList<Pair<String, Command>>();
    private List<MenuItem> topLevelMenus = new ArrayList<MenuItem>();
    private List<MenuItem> menuItemsSyncedWithLockState = new ArrayList<MenuItem>();
    private HasLockSyncMenuStateHelper.LockSyncMenuStateHelper lockSyncMenuStateHelper = new HasLockSyncMenuStateHelper.BasicLockSyncMenuStateHelper();

    @Inject
    public BasicFileMenuBuilderImpl(DeletePopUpPresenter deletePopUpPresenter, CopyPopUpPresenter copyPopUpPresenter, RenamePopUpPresenter renamePopUpPresenter, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notification, RestoreVersionCommandProvider restoreVersionCommandProvider) {
        this.deletePopUpPresenter = deletePopUpPresenter;
        this.copyPopUpPresenter = copyPopUpPresenter;
        this.renamePopUpPresenter = renamePopUpPresenter;
        this.busyIndicatorView = busyIndicatorView;
        this.notification = notification;
        this.restoreVersionCommandProvider = restoreVersionCommandProvider;
    }

    @Override
    public BasicFileMenuBuilder addSave(MenuItem menuItem) {
        this.saveMenuItem = menuItem;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addSave(Command command) {
        this.saveCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addDelete(Path path, Caller<? extends SupportsDelete> deleteCaller) {
        return this.addDelete(path, deleteCaller, null);
    }

    @Override
    public BasicFileMenuBuilder addDelete(Path path, Caller<? extends SupportsDelete> deleteCaller, Validator validator) {
        return this.addDelete(() -> this.deletePopUpPresenter.show(validator, (ParameterizedCommand<String>)((ParameterizedCommand)comment -> {
            this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Deleting());
            ((SupportsDelete)deleteCaller.call(this.getDeleteSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).delete(path, comment);
        })));
    }

    @Override
    public BasicFileMenuBuilder addDelete(BasicFileMenuBuilder.PathProvider provider, Caller<? extends SupportsDelete> deleteCaller) {
        return this.addDelete(provider, deleteCaller, null);
    }

    @Override
    public BasicFileMenuBuilder addDelete(BasicFileMenuBuilder.PathProvider provider, Caller<? extends SupportsDelete> deleteCaller, Validator validator) {
        return this.addDelete(() -> {
            Path path = provider.getPath();
            this.deletePopUpPresenter.show(validator, (ParameterizedCommand<String>)((ParameterizedCommand)comment -> {
                this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Deleting());
                ((SupportsDelete)deleteCaller.call(this.getDeleteSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).delete(path, comment);
            }));
        });
    }

    private RemoteCallback<Void> getDeleteSuccessCallback() {
        return v -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully()));
        };
    }

    @Override
    public BasicFileMenuBuilder addDelete(Command command) {
        this.deleteCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addRename(Command command) {
        this.renameCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addRename(Path path, Caller<? extends SupportsRename> renameCaller) {
        return this.addRename(() -> {
            CommandWithFileNameAndCommitMessage command = this.getRenamePopupCommand(renameCaller, path, this.renamePopUpPresenter.getView());
            this.renamePopUpPresenter.show(path, command);
        });
    }

    @Override
    public BasicFileMenuBuilder addRename(Path path, Validator validator, Caller<? extends SupportsRename> renameCaller) {
        return this.addRename(() -> {
            CommandWithFileNameAndCommitMessage command = this.getRenamePopupCommand(renameCaller, path, this.renamePopUpPresenter.getView());
            this.renamePopUpPresenter.show(path, validator, command);
        });
    }

    @Override
    public BasicFileMenuBuilder addRename(BasicFileMenuBuilder.PathProvider provider, Validator validator, Caller<? extends SupportsRename> renameCaller) {
        return this.addRename(() -> {
            Path path = provider.getPath();
            CommandWithFileNameAndCommitMessage command = this.getRenamePopupCommand(renameCaller, path, this.renamePopUpPresenter.getView());
            this.renamePopUpPresenter.show(path, validator, command);
        });
    }

    private CommandWithFileNameAndCommitMessage getRenamePopupCommand(Caller<? extends SupportsRename> renameCaller, Path path, RenamePopUpPresenter.View renamePopupView) {
        return details -> {
            this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Renaming());
            ((SupportsRename)renameCaller.call(this.getRenameSuccessCallback(renamePopupView), (ErrorCallback)this.getRenameErrorCallback(renamePopupView, this.busyIndicatorView))).rename(path, details.getNewFileName(), details.getCommitMessage());
        };
    }

    private RemoteCallback<Path> getRenameSuccessCallback(RenamePopUpPresenter.View renamePopupView) {
        return path -> {
            renamePopupView.hide();
            this.busyIndicatorView.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRenamedSuccessfully()));
        };
    }

    private HasBusyIndicatorDefaultErrorCallback getRenameErrorCallback(final RenamePopUpPresenter.View renamePopupView, BusyIndicatorView busyIndicatorView) {
        return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)busyIndicatorView){

            public boolean error(Message message, Throwable throwable) {
                if (BasicFileMenuBuilderImpl.this.fileAlreadyExists(throwable)) {
                    this.hideBusyIndicator();
                    renamePopupView.handleDuplicatedFileName();
                    return false;
                }
                renamePopupView.hide();
                return super.error(message, throwable);
            }
        };
    }

    @Override
    public BasicFileMenuBuilder addCopy(Command command) {
        this.copyCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addCopy(Path path, Caller<? extends SupportsCopy> copyCaller) {
        return this.addCopy(() -> this.copyPopUpPresenter.show(path, this.getCopyPopupCommand(copyCaller, path, this.copyPopUpPresenter.getView())));
    }

    @Override
    public BasicFileMenuBuilder addCopy(Path path, Validator validator, Caller<? extends SupportsCopy> copyCaller) {
        return this.addCopy(() -> this.copyPopUpPresenter.show(path, validator, this.getCopyPopupCommand(copyCaller, path, this.copyPopUpPresenter.getView())));
    }

    @Override
    public BasicFileMenuBuilder addCopy(BasicFileMenuBuilder.PathProvider provider, Validator validator, Caller<? extends SupportsCopy> copyCaller) {
        return this.addCopy(() -> {
            Path path = provider.getPath();
            this.copyPopUpPresenter.show(path, validator, this.getCopyPopupCommand(copyCaller, path, this.copyPopUpPresenter.getView()));
        });
    }

    private CommandWithFileNameAndCommitMessage getCopyPopupCommand(Caller<? extends SupportsCopy> copyCaller, Path path, CopyPopUpPresenter.View copyPopupView) {
        return details -> {
            this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Copying());
            ((SupportsCopy)copyCaller.call(this.getCopySuccessCallback(copyPopupView), (ErrorCallback)this.getCopyErrorCallback(copyPopupView, this.busyIndicatorView))).copy(path, details.getNewFileName(), copyPopupView.getTargetPath(), details.getCommitMessage());
        };
    }

    private RemoteCallback<Path> getCopySuccessCallback(CopyPopUpPresenter.View copyPopupView) {
        return path -> {
            copyPopupView.hide();
            this.busyIndicatorView.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCopiedSuccessfully()));
        };
    }

    public HasBusyIndicatorDefaultErrorCallback getCopyErrorCallback(final CopyPopUpPresenter.View copyPopupView, BusyIndicatorView busyIndicatorView) {
        return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)busyIndicatorView){

            public boolean error(Message message, Throwable throwable) {
                if (BasicFileMenuBuilderImpl.this.fileAlreadyExists(throwable)) {
                    this.hideBusyIndicator();
                    copyPopupView.handleDuplicatedFileName();
                    return false;
                }
                copyPopupView.hide();
                return super.error(message, throwable);
            }
        };
    }

    private boolean fileAlreadyExists(Throwable throwable) {
        return throwable != null && throwable.getMessage() != null && throwable.getMessage().contains("FileAlreadyExistsException");
    }

    @Override
    public BasicFileMenuBuilder addValidate(Command validateCommand) {
        this.validateCommand = validateCommand;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addRestoreVersion(Path path) {
        this.restoreCommand = this.restoreVersionCommandProvider.getCommand(path);
        return this;
    }

    @Override
    public BasicFileMenuBuilder addCommand(String caption, Command command) {
        this.otherCommands.add((Pair<String, Command>)new Pair((Object)caption, (Object)command));
        return this;
    }

    @Override
    public Menus build() {
        final LinkedHashMap<MenuItems, Object> menuItems = new LinkedHashMap<MenuItems, Object>();
        if (this.saveCommand != null) {
            menuItems.put(MenuItems.SAVE, ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Save()).respondsWith(this.saveCommand)).endMenu()).build().getItems().get(0));
        } else if (this.saveMenuItem != null) {
            menuItems.put(MenuItems.SAVE, this.saveMenuItem);
            this.menuItemsSyncedWithLockState.add(this.saveMenuItem);
        }
        if (this.deleteCommand != null) {
            if (this.deleteMenuItem == null) {
                this.deleteMenuItem = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Delete()).respondsWith(this.deleteCommand)).endMenu()).build().getItems().get(0);
            }
            menuItems.put(MenuItems.DELETE, this.deleteMenuItem);
            this.menuItemsSyncedWithLockState.add(this.deleteMenuItem);
        }
        if (this.renameCommand != null) {
            if (this.renameMenuItem == null) {
                this.renameMenuItem = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Rename()).respondsWith(this.renameCommand)).endMenu()).build().getItems().get(0);
            }
            menuItems.put(MenuItems.RENAME, this.renameMenuItem);
            this.menuItemsSyncedWithLockState.add(this.renameMenuItem);
        }
        if (this.copyCommand != null) {
            menuItems.put(MenuItems.COPY, ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Copy()).respondsWith(this.copyCommand)).endMenu()).build().getItems().get(0));
        }
        if (this.validateCommand != null) {
            menuItems.put(MenuItems.VALIDATE, ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Validate()).respondsWith(this.validateCommand)).endMenu()).build().getItems().get(0));
        }
        if (this.restoreCommand != null) {
            if (this.restoreMenuItem == null) {
                this.restoreMenuItem = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Restore()).respondsWith(this.restoreCommand)).endMenu()).build().getItems().get(0);
            }
            this.menuItemsSyncedWithLockState.add(this.restoreMenuItem);
        }
        if (this.otherCommands != null && !this.otherCommands.isEmpty()) {
            ArrayList otherMenuItems = new ArrayList();
            for (Pair<String, Command> other : this.otherCommands) {
                otherMenuItems.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)((String)other.getK1())).respondsWith((Command)other.getK2())).endMenu()).build().getItems().get(0));
            }
            MenuItem item = (MenuItem)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Other()).withItems(otherMenuItems).endMenu()).build().getItems().get(0);
            menuItems.put((MenuItems)item, item);
        }
        for (MenuItem menuItem : this.topLevelMenus) {
            menuItems.put((MenuItems)menuItem, menuItem);
        }
        return new Menus(){

            public List<MenuItem> getItems() {
                return new ArrayList<MenuItem>(){
                    {
                        for (MenuItem menuItem : menuItems.values()) {
                            this.add(menuItem);
                        }
                    }
                };
            }

            public Map<Object, MenuItem> getItemsMap() {
                return menuItems;
            }

            public void accept(MenuVisitor visitor) {
                if (visitor.visitEnter((Menus)this)) {
                    for (MenuItem item : menuItems.values()) {
                        item.accept(visitor);
                    }
                    visitor.visitLeave((Menus)this);
                }
            }

            public int getOrder() {
                return 0;
            }
        };
    }

    @Override
    public BasicFileMenuBuilder addNewTopLevelMenu(MenuItem menu) {
        this.topLevelMenus.add(menu);
        return this;
    }

    @Override
    public void setLockSyncMenuStateHelper(HasLockSyncMenuStateHelper.LockSyncMenuStateHelper lockSyncMenuStateHelper) {
        this.lockSyncMenuStateHelper = (HasLockSyncMenuStateHelper.LockSyncMenuStateHelper)PortablePreconditions.checkNotNull((String)"lockSyncMenuStateHelper", (Object)lockSyncMenuStateHelper);
    }

    void onEditorLockInfo(@Observes UpdatedLockStatusEvent lockInfo) {
        HasLockSyncMenuStateHelper.LockSyncMenuStateHelper.Operation op = this.lockSyncMenuStateHelper.enable(lockInfo.getFile(), lockInfo.isLocked(), lockInfo.isLockedByCurrentUser());
        switch (op) {
            case ENABLE: 
            case DISABLE: {
                for (MenuItem menuItem : this.menuItemsSyncedWithLockState) {
                    menuItem.setEnabled(op == HasLockSyncMenuStateHelper.LockSyncMenuStateHelper.Operation.ENABLE);
                }
                break;
            }
        }
    }
}

